#include "LPP-PDU-Definitions.h"
#include "rtxsrc/rtxDiag.h"
#include "rtxsrc/rtxFile.h"

#include <stdio.h>
#include <stdlib.h>

int main (int argc, char** argv)
{
   LPP_Message data;
   OSCTXT      ctxt;
   OSOCTET*    pMsgBuf;
   OSBOOL      aligned = TRUE;
   const char* filename = "message.per";
   OSBOOL      trace = TRUE, verbose = FALSE;
   int         i, stat;
   OSSIZE      len;

   /* Process command line arguments */
   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) verbose = TRUE;
         else if (!strcmp (argv[i], "-i")) filename = argv[++i];
         else if (!strcmp (argv[i], "-a")) aligned = TRUE;
         else if (!strcmp (argv[i], "-u")) {
            aligned = FALSE;
            filename = "message.uper";
         }
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: reader [-v] [-i <filename>] [-a|-u] [-notrace]\n");
            printf ("   -v  verbose mode: print trace info\n");
            printf ("   -i <filename>  read encoded msg from <filename>\n");
            printf ("   -a  use PER aligned encoding\n");
            printf ("   -u  use PER unaligned encoding\n");
            printf ("   -notrace  do not display trace info\n");
            return 1;
         }
      }
   }

   /* Initialize context structure */
   stat = rtInitContext (&ctxt);
   if (stat != 0) {
      rtxErrPrint (&ctxt);
      return stat;
   }
   rtxSetDiag (&ctxt, verbose);

   /* Read input file into a memory buffer */
   if (0 != rtxFileReadBinary (&ctxt, filename, &pMsgBuf, &len)) {
      printf ("Error opening %s for read access\n", filename);
      return -1;
   }

   pu_setBuffer (&ctxt, pMsgBuf, len, aligned);
   pu_setTrace (&ctxt, trace);

   asn1Init_LPP_Message (&data);

   /* Call compiler generated decode function */
   stat = asn1PD_LPP_Message (&ctxt, &data);

   if (trace) {
   }

   if (stat != 0) {
      printf ("decode of data failed\n");
      rtxErrPrint (&ctxt);
   }
   else if (trace) {
      asn1Print_LPP_Message ("Data", &data);
   }

   rtFreeContext (&ctxt);

   return stat;
}

