#include "LPP-PDU-Definitions.h"
#include "rtxsrc/rtxDiag.h"
#include "rtxsrc/rtxFile.h"

#include "rtxsrc/rtxPrint.h"

int main (int argc, char** argv)
{
   /* PDU: LPP-PDU-Definitions.LPP_Message */
   LPP_Message pdu;
   OSCTXT      ctxt;
   int         i, len, stat;
   OSBOOL      aligned = TRUE;
   OSBOOL      trace = TRUE;
   OSBOOL      verbose = FALSE;
   const char* filename = "message.per";
   const OSOCTET* msgptr;

   /* Process command line arguments */
   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) verbose = TRUE;
         else if (!strcmp (argv[i], "-o")) filename = argv[++i];
         else if (!strcmp (argv[i], "-a")) aligned = TRUE;
         else if (!strcmp (argv[i], "-u")) {
            aligned = FALSE;
            filename = "message.uper";
         }
         else if (!strcmp (argv[i], "-u")) aligned = FALSE;
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: writer -a | -u [-v] [-o <filename>]  [-notrace]\n");
            printf ("   -a  use PER aligned encoding\n");
            printf ("   -u  use PER unaligned encoding\n");
            printf ("   -v  verbose mode: print trace info\n");
            printf ("   -o <filename>  write encoded msg to <filename>\n");
            printf ("   -notrace  do not display trace info\n");
            return 1;
         }
      }
   }

   /* Initialize context structure */
   stat = rtInitContext (&ctxt);
   if (stat != 0) {
      rtxErrPrint (&ctxt);
      return stat;
   }
   rtxSetDiag (&ctxt, verbose);
   pu_setBuffer (&ctxt, 0, 0, aligned);
   pu_setTrace (&ctxt, trace);

   asn1Init_LPP_Message (&pdu);

   pdu.m.transactionIDPresent = 1;
   pdu.transactionID.initiator = Initiator_targetDevice;
   pdu.transactionID.transactionNumber = 113;

   pdu.endTransaction = FALSE;

   pdu.m.sequenceNumberPresent = 1;
   pdu.sequenceNumber = 31;

   pdu.m.acknowledgementPresent = 1;
   pdu.acknowledgement.ackRequested = TRUE;
   pdu.acknowledgement.m.ackIndicatorPresent = 1;
   pdu.acknowledgement.ackIndicator = 248;

   pdu.m.lpp_MessageBodyPresent = 1;
   pdu.lpp_MessageBody.t = 1;
   pdu.lpp_MessageBody.u.c1 = rtxMemAllocTypeZ (&ctxt, LPP_MessageBody_c1);
   pdu.lpp_MessageBody.u.c1->t = 4; // ProvideAssistanceData
   pdu.lpp_MessageBody.u.c1->u.provideAssistanceData = rtxMemAllocTypeZ (&ctxt, ProvideAssistanceData);
   pdu.lpp_MessageBody.u.c1->u.provideAssistanceData->criticalExtensions.t = 1;
   pdu.lpp_MessageBody.u.c1->u.provideAssistanceData->criticalExtensions.u.c1 = rtxMemAllocTypeZ (&ctxt, ProvideAssistanceData_criticalExtensions_c1);
   pdu.lpp_MessageBody.u.c1->u.provideAssistanceData->criticalExtensions.u.c1->t = 1;
   pdu.lpp_MessageBody.u.c1->u.provideAssistanceData->criticalExtensions.u.c1->u.provideAssistanceData_r9 = rtxMemAllocTypeZ (&ctxt, ProvideAssistanceData_r9_IEs);
   pdu.lpp_MessageBody.u.c1->u.provideAssistanceData->criticalExtensions.u.c1->u.provideAssistanceData_r9->m.commonIEsProvideAssistanceDataPresent = 1;
   pdu.lpp_MessageBody.u.c1->u.provideAssistanceData->criticalExtensions.u.c1->u.provideAssistanceData_r9->commonIEsProvideAssistanceData.m._v2ExtPresent = 1;
   pdu.lpp_MessageBody.u.c1->u.provideAssistanceData->criticalExtensions.u.c1->u.provideAssistanceData_r9->commonIEsProvideAssistanceData.m.segmentationInfo_r14Present = 1;
   pdu.lpp_MessageBody.u.c1->u.provideAssistanceData->criticalExtensions.u.c1->u.provideAssistanceData_r9->commonIEsProvideAssistanceData.segmentationInfo_r14 = SegmentationInfo_r14_moreMessagesOnTheWay;

   if (trace) {
      printf ("The following record will be encoded:\n");
      asn1Print_LPP_Message ("LPP_Message", &pdu);
      printf ("\n");
   }

   /* Encode */
   stat = asn1PE_LPP_Message (&ctxt, &pdu);

   msgptr = pe_GetMsgPtr (&ctxt, &len);

   if (trace) {
      printf ("Hex dump of encoded record:\n");
      rtxHexDump (msgptr, len);
   }
   if (stat < 0) {
      printf ("Encoding failed\n");
      rtxErrPrint (&ctxt);
      rtFreeContext (&ctxt);
      return stat;
   }
   /* Write the encoded message out to the output file */
   stat = rtxFileWriteBinary (filename, msgptr, len);
   if (stat < 0) {
      printf ("Write to file failed\n");
      rtxErrPrint (&ctxt);
      rtFreeContext (&ctxt);
      return stat;
   }

   rtFreeContext (&ctxt);

   return 0;
}

