/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 7.5.0, Date: 08-Mar-2021.
 */
#include "NR-RRC-Definitions.h"
#include "rtxsrc/rtxCommon.h"

#include "rtxsrc/rtxPrint.h"

int main (int argc, char** argv)
{
   /* ASN1C generated type variables */
   UL_DCCH_MessageType ul_dcch;
   UL_DCCH_MessageType_c1 c1;
   RRCReconfigurationComplete reconfigComplete;
   RRCReconfigurationComplete_IEs reconfigIEs;
   
   /* Run-time variables */
   OSCTXT     ctxt;
   int        i, len, stat;
   OSBOOL     trace = TRUE;
   OSBOOL     verbose = FALSE;
   const char* filename = "message.uper";
   const OSOCTET* msgptr;
   OSOCTET    ocs[10];

   /* Process command line arguments */
   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) verbose = TRUE;
         else if (!strcmp (argv[i], "-o")) filename = argv[++i];
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: writer [-v] [-o <filename>]  [-notrace]\n");
            printf ("   -v  verbose mode: print trace info\n");
            printf ("   -o <filename>  write encoded msg to <filename>\n");
            printf ("   -notrace  do not display trace info\n");
            return 1;
         }
      }
   }

   /* Initialize context structure */
   stat = rtInitContext (&ctxt);
   if (stat != 0) {
      rtxErrPrint (&ctxt);
      return stat;
   }
   rtxSetDiag (&ctxt, verbose);
   pu_setBuffer (&ctxt, 0, 0, FALSE);
   pu_setTrace (&ctxt, trace);

   /* Populate message structure */
   ul_dcch.t = T_UL_DCCH_MessageType_c1;
   ul_dcch.u.c1 = &c1;

   c1.t = T_UL_DCCH_MessageType_c1_rrcReconfigurationComplete;
   c1.u.rrcReconfigurationComplete = &reconfigComplete;

   asn1Init_RRCReconfigurationComplete (&reconfigComplete);
   reconfigComplete.rrc_TransactionIdentifier = 2;
   reconfigComplete.criticalExtensions.t = T_RRCReconfiguration_criticalExtensions_rrcReconfiguration;
   reconfigComplete.criticalExtensions.u.rrcReconfigurationComplete = &reconfigIEs;

   for (i = 0; i < (int)sizeof (ocs);i++) {
      ocs [i] = (OSOCTET)i;
   }
   reconfigIEs.m.lateNonCriticalExtensionPresent = 1;
   reconfigIEs.lateNonCriticalExtension.numocts = sizeof (ocs);
   reconfigIEs.lateNonCriticalExtension.data = ocs;

   if (trace) {
      printf ("The following record will be encoded:\n");
      asn1Print_UL_DCCH_MessageType ("ul_dcch", &ul_dcch);
      printf ("\n");
   }

   /* Encode */
   stat = asn1PE_UL_DCCH_MessageType (&ctxt, &ul_dcch);

   msgptr = pe_GetMsgPtr (&ctxt, &len);

   if (trace) {
      printf ("Hex dump of encoded record:\n");
      rtxHexDump (msgptr, len);
      
      printf ("Binary dump:\n");
      pu_bindump (&ctxt, "data");
   }
   if (stat < 0) {
      printf ("Encoding failed\n");
      rtxErrPrint (&ctxt);
      rtFreeContext (&ctxt);
      return stat;
   }
   /* Write the encoded message out to the output file */
   stat = rtxFileWriteBinary (filename, msgptr, len);
   if (stat < 0) {
      printf ("Write to file failed\n");
      rtxErrPrint (&ctxt);
      rtFreeContext (&ctxt);
      return stat;
   }

   rtFreeContext (&ctxt);

   return 0;
}
