/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 7.5.0, Date: 08-Mar-2021.
 */
#include "EUTRA-RRC-Definitions.h"
#include "rtxsrc/rtxCommon.h"

#include "rtxsrc/rtxPrint.h"

int main (int argc, char** argv)
{
   /* ASN1C generated type variables */
   UL_DCCH_MessageType ul_dcch;
   UL_DCCH_MessageType_c1 c1;
   MeasurementReport measReport;
   MeasurementReport_criticalExtensions_c1 measReportC1;
   MeasurementReport_r8_IEs measReportR8IEs;

   /* Run-time variables */
   OSCTXT     ctxt;
   int        i, len, stat;
   OSBOOL     trace = TRUE;
   OSBOOL     verbose = FALSE;
   const char* filename = "message.uper";
   const OSOCTET* msgptr;

   /* Process command line arguments */
   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) verbose = TRUE;
         else if (!strcmp (argv[i], "-o")) filename = argv[++i];
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: writer [-v] [-o <filename>]  [-notrace]\n");
            printf ("   -v  verbose mode: print trace info\n");
            printf ("   -o <filename>  write encoded msg to <filename>\n");
            printf ("   -notrace  do not display trace info\n");
            return 1;
         }
      }
   }

   /* Initialize context structure */
   stat = rtInitContext (&ctxt);
   if (stat != 0) {
      rtxErrPrint (&ctxt);
      return stat;
   }
   rtxSetDiag (&ctxt, verbose);
   pu_setBuffer (&ctxt, 0, 0, FALSE);
   pu_setTrace (&ctxt, trace);

   /* Populate message structure */
   ul_dcch.t = T_UL_DCCH_MessageType_c1;
   ul_dcch.u.c1 = &c1;

   c1.t = T_UL_DCCH_MessageType_c1_measurementReport;
   c1.u.measurementReport = &measReport;

   asn1Init_MeasurementReport (&measReport);
   measReport.criticalExtensions.t = T_MeasurementReport_criticalExtensions_c1;
   measReport.criticalExtensions.u.c1 = &measReportC1;

   measReportC1.t = 
      T_MeasurementReport_criticalExtensions_c1_measurementReport_r8;
   measReportC1.u.measurementReport_r8 = &measReportR8IEs;

   asn1Init_MeasurementReport_r8_IEs (&measReportR8IEs);
   measReportR8IEs.m.nonCriticalExtensionPresent = 0;

   measReportR8IEs.measResults.m.measResultNeighCellsPresent = 0;

   measReportR8IEs.measResults.measId = 1;  // an unsigned 8-bit integer

   /* The element name in this type is different in R10 */
#ifdef ASN1V_maxBandComb_r10
   measReportR8IEs.measResults.measResultPCell.rsrpResult = 0;
   measReportR8IEs.measResults.measResultPCell.rsrqResult = 0;
#else
   measReportR8IEs.measResults.measResultServCell.rsrpResult = 0;
   measReportR8IEs.measResults.measResultServCell.rsrqResult = 0;
#endif

   if (trace) {
      printf ("The following record will be encoded:\n");
      asn1Print_UL_DCCH_MessageType ("ul_dcch", &ul_dcch);
      printf ("\n");
   }

   /* Encode */
   stat = asn1PE_UL_DCCH_MessageType (&ctxt, &ul_dcch);

   msgptr = pe_GetMsgPtr (&ctxt, &len);

   if (trace) {
      printf ("Hex dump of encoded record:\n");
      rtxHexDump (msgptr, len);
      
      printf ("Binary dump:\n");
      pu_bindump (&ctxt, "data");
   }
   if (stat < 0) {
      printf ("Encoding failed\n");
      rtxErrPrint (&ctxt);
      rtFreeContext (&ctxt);
      return stat;
   }
   /* Write the encoded message out to the output file */
   stat = rtxFileWriteBinary (filename, msgptr, len);
   if (stat < 0) {
      printf ("Write to file failed\n");
      rtxErrPrint (&ctxt);
      rtFreeContext (&ctxt);
      return stat;
   }

   rtFreeContext (&ctxt);

   return 0;
}
