/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 7.5.0, Date: 08-Mar-2021.
 */
#include "NGAP-PDU-Descriptions.h"
#include "NGAP-Constants.h"
#include "rtxsrc/rtxCommon.h"

#include "rtxsrc/rtxPrint.h"

/* functions for populating an InitiatingMessage */
InitiatingMessage *populate_InitMsg (OSCTXT *pctxt);
UEContextReleaseRequest_protocolIEs_element *populate_UECRRElem (OSCTXT *pctxt);

int main (int argc, char** argv)
{
   /* PDU: NGAP-PDU-Descriptions.NGAP_PDU */
   NGAP_PDU   pdu;
   OSCTXT     ctxt;
   int        i, len, stat;
   OSBOOL     trace = TRUE;
   OSBOOL     verbose = FALSE;
   const char* filename = "message.per";
   const OSOCTET* msgptr;

   /* Process command line arguments */
   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) verbose = TRUE;
         else if (!strcmp (argv[i], "-o")) filename = argv[++i];
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: writer [-v] [-o <filename>]  [-notrace]\n");
            printf ("   -v  verbose mode: print trace info\n");
            printf ("   -o <filename>  write encoded msg to <filename>\n");
            printf ("   -notrace  do not display trace info\n");
            return 1;
         }
      }
   }

   /* Initialize context structure */
   stat = rtInitContext (&ctxt);
   if (stat != 0) {
      rtxErrPrint (&ctxt);
      return stat;
   }
   rtxSetDiag (&ctxt, verbose);
   pu_setBuffer (&ctxt, 0, 0, TRUE);
   pu_setTrace (&ctxt, trace);

   pdu.t = T_NGAP_PDU_initiatingMessage;
   pdu.u.initiatingMessage = populate_InitMsg (&ctxt);

   if (trace) {
      printf ("The following record will be encoded:\n");
      asn1Print_NGAP_PDU ("NGAP_PDU", &pdu);
      printf ("\n");
   }

   /* Encode */
   if ((stat = asn1PE_NGAP_PDU (&ctxt, &pdu))== 0) {
      if (trace) {
         printf ("Encoding was successful\n");
         printf ("Hex dump of encoded record:\n");
         pu_hexdump (&ctxt);
         printf ("Binary dump:\n");
         pu_bindump (&ctxt, "NGAP_PDU");
      }
   }
   else {
      printf ("Encoding failed\n");
      rtxErrPrint (&ctxt);
      rtFreeContext (&ctxt);
      return -1;
   }
   msgptr = pe_GetMsgPtr (&ctxt, &len);

   /* Write the encoded message out to the output file */
   stat = rtxFileWriteBinary (filename, msgptr, len);
   if (stat < 0) {
      printf ("Error opening %s for write access\n", filename);
   }

   rtFreeContext (&ctxt);

   return stat;
}

InitiatingMessage *populate_InitMsg (OSCTXT *pctxt) 
{
   InitiatingMessage* pvalue = rtxMemAllocType (pctxt, InitiatingMessage);
   asn1Init_InitiatingMessage (pvalue);

   pvalue->procedureCode = ASN1V_id_UEContextReleaseRequest;
   pvalue->criticality = Criticality_ignore;

   pvalue->value.t = T_NGPDUDescr_XEP_uEContextReleaseRequest;
   pvalue->value.u.uEContextReleaseRequest = 
      (UEContextReleaseRequest*)rtxMemAllocZ(pctxt, sizeof(UEContextReleaseRequest));

   {
      OSRTDList* plist = &pvalue->value.u.uEContextReleaseRequest->protocolIEs;
      UEContextReleaseRequest_protocolIEs_element* pdata;
      rtxDListInit (plist);

      pdata = populate_UECRRElem (pctxt);

      rtxDListAppend (pctxt, plist, (void*)pdata);

   }

   rtxDListInit(&(pvalue->value.u.uEContextReleaseRequest->extElem1));
   return (pvalue);
}

UEContextReleaseRequest_protocolIEs_element *populate_UECRRElem (OSCTXT *pctxt)
{
   UEContextReleaseRequest_protocolIEs_element* pvalue = 
      rtxMemAllocType (pctxt, UEContextReleaseRequest_protocolIEs_element);
   asn1Init_UEContextReleaseRequest_protocolIEs_element (pvalue);

   pvalue->id = 40;
   pvalue->criticality = Criticality_ignore;
   
   pvalue->value.t = T_NGPDUCont_UEContextReleaseRequest_IEs_id_AMF_UE_NGAP_ID;
   pvalue->value.u._UEContextReleaseRequest_IEs_id_AMF_UE_NGAP_ID = 128;
   return (pvalue);
}

