/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 7.5.0, Date: 08-Mar-2021.
 */
#include "S1AP-PDU-Descriptions.h"
#include "S1AP-PDU-Contents.h"
#include "S1AP-Constants.h"
#include "rtxsrc/rtxCommon.h"

#include "rtxsrc/rtxPrint.h"

/* methods to populate types with test data */
InitiatingMessage  *pop_InitMsg (OSCTXT *pctxt);
UECapabilityInfoIndication_protocolIEs_element *pop_CapElem (OSCTXT *pctxt);

int main (int argc, char** argv)
{
   S1AP_PDU   pdu;
   OSCTXT     ctxt;
   int        i, len, stat;
   OSBOOL     trace = TRUE;
   OSBOOL     verbose = FALSE;
   const char* filename = "message.per";
   const OSOCTET* msgptr;

   /* Process command line arguments */
   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) verbose = TRUE;
         else if (!strcmp (argv[i], "-o")) filename = argv[++i];
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: writer [-v] [-o <filename>]  [-notrace]\n");
            printf ("   -v  verbose mode: print trace info\n");
            printf ("   -o <filename>  write encoded msg to <filename>\n");
            printf ("   -notrace  do not display trace info\n");
            return 1;
         }
      }
   }

   /* Initialize context structure */
   stat = rtInitContext (&ctxt);
   if (stat != 0) {
      rtxErrPrint (&ctxt);
      return stat;
   }
   rtxSetDiag (&ctxt, verbose);
   pu_setBuffer (&ctxt, 0, 0, TRUE);
   pu_setTrace (&ctxt, trace);

   pdu.t = T_S1AP_PDU_initiatingMessage;
   pdu.u.initiatingMessage = pop_InitMsg (&ctxt);

   if (trace) {
      printf ("The following record will be encoded:\n");
      asn1Print_S1AP_PDU ("S1AP_PDU", &pdu);
      printf ("\n");
   }

   /* Encode */
   if ((stat = asn1PE_S1AP_PDU (&ctxt, &pdu))== 0) {
      if (trace) {
         printf ("Encoding was successful\n");
         printf ("Hex dump of encoded record:\n");
         pu_hexdump (&ctxt);
         printf ("Binary dump:\n");
         pu_bindump (&ctxt, "S1AP_PDU");
      }
   }
   else {
      printf ("Encoding failed\n");
      rtxErrPrint (&ctxt);
      rtFreeContext (&ctxt);
      return -1;
   }
   msgptr = pe_GetMsgPtr (&ctxt, &len);

   /* Write the encoded message out to the output file */
   stat = rtxFileWriteBinary (filename, msgptr, len);
   if (stat < 0) {
      printf ("Error opening %s for write access\n", filename);
   }

   rtFreeContext (&ctxt);

   return stat;
}

InitiatingMessage *pop_InitMsg (OSCTXT *pctxt) 
{
   OSRTDList* plist;
   UECapabilityInfoIndication_protocolIEs_element* pdata;
   InitiatingMessage* pvalue = rtxMemAllocType (pctxt, InitiatingMessage);
   asn1Init_InitiatingMessage (pvalue);

   pvalue->procedureCode = ASN1V_id_UECapabilityInfoIndication;
   pvalue->criticality = Criticality_reject;

   pvalue->value.t = T_S1PDUDescr_SEP_uECapabilityInfoIndication;
   pvalue->value.u.uECapabilityInfoIndication = 
      rtxMemAllocType (pctxt, UECapabilityInfoIndication);

   asn1Init_UECapabilityInfoIndication 
      (pvalue->value.u.uECapabilityInfoIndication);

   plist = &pvalue->value.u.uECapabilityInfoIndication->protocolIEs;

   rtxDListInit (plist);

   pdata = pop_CapElem (pctxt);

   rtxDListAppend (pctxt, plist, (void*)pdata);

   return (pvalue);
}

UECapabilityInfoIndication_protocolIEs_element *pop_CapElem (OSCTXT *pctxt)
{
   UECapabilityInfoIndication_protocolIEs_element* pvalue = 
      rtxMemAllocType (pctxt, UECapabilityInfoIndication_protocolIEs_element);

   asn1Init_UECapabilityInfoIndication_protocolIEs_element (pvalue);

   pvalue->id = ASN1V_id_eNB_UE_S1AP_ID;
   pvalue->criticality = Criticality_reject;
   pvalue->value.t = 
      T_S1PDUCont_UECapabilityInfoIndicationIEs_id_eNB_UE_S1AP_ID;
   pvalue->value.u._UECapabilityInfoIndicationIEs_id_eNB_UE_S1AP_ID = 16320995;
   
   return (pvalue);
}

