#!/usr/local/bin/perl
# Execute all sample programs in given subdirectory

select (STDERR);
$| = 1;
select (STDOUT);
$| = 1;

if (@ARGV < 1) {
    print "usage: sample.pl <function> [<make program>]\n";
    print "where <function> = test or clean\n";
    print "      [<make program>] = the optional makefile processor\n";
}

$function = $ARGV[0];
if ($function ne 'test' && $function ne 'clean') {
    die ("invalid function argument: must be test or clean");
}

$makeprog = ($ARGV[1] ne "") ? $ARGV[1] : &getMakeProg;

# try to determine if Windows or UNIX platform type
$os = $ENV{'OS'};
$win32 = ($os =~ /Windows/);

if (! $win32) {
   $ENV{'PATH'} .= ":.";
}

&execSamples ("sample", $function);

sub execSamples {
    local ($dirName) = @_;
    return if (!(-e $dirName));

    chdir ($dirName) || die ("could not chdir to $dirName");
    @dirlist = (`ls .`);

    foreach $filename (@dirlist) {
        $filename =~ s/\n$//;

        if (-d $filename) {
            chdir ($filename);

            # execute test procedure

            if (-e "makefile") {
                if ($function eq "test") {
                    print "$filename\n";
                    `$makeprog`;

                    if (-e "writer.exe" || -e "writer") {
                        print ("writer ");
                        @proglist = ("writer", "-notrace");
                        $stat = system (@proglist);
                        if ($stat == 0) { print ("OK\n"); } 
                        else { print ("failed.\n"); }
                    }

                    if (-e "reader.exe" || -e "reader") {
                        print ("reader ");
                        @proglist = ("reader", "-notrace");
                        $stat = system (@proglist);
                        if ($stat == 0) { print ("OK\n"); } 
                        else { print ("failed.\n"); }
                    }

                    print "\n";
                    print "**************************************";
                    print "**************************************\n";
                    print "\n";
                }
                elsif ($function eq "clean") {
                    print ("cleaning $filename..\n");
                        `$makeprog clean`;
                }
            }

            chdir ('..');
        }
    }

    chdir ('..');
}

sub getMakeProg {
    my $makeprog = "make";
    if (defined ($ENV{'MAKEPROG'})) {
        $makeprog = $ENV{'MAKEPROG'};
    }
    elsif (defined ($ENV{'MSVCDIR'}) || 
           defined ($ENV{'MSDEVDIR'}) ||
           defined ($ENV{'MSDevDir'}) ||
	   defined ($ENV{'VCINSTALLDIR'})) {
        $makeprog = "nmake -nologo";
    }
    else {
        $makeprog = "make";
    }
    return $makeprog;
}

