/* This test driver program encodes a data record and writes the        */
/* encoded result to an output file..                                   */

#include <stdio.h>
#include <stdlib.h>
#include "CSTA-device-identifiers.h"

#define MAXMSGLEN 1024

static void setDeviceIds (ASN1BEREncodeBuffer& encodeBuffer);

int main (int argc, char** argv)
{
      ASN1BEREncodeBuffer encodeBuffer;
      setDeviceIds (encodeBuffer);

   return 0;

}

/* set DeviceID values */

static void setDeviceIds (ASN1BEREncodeBuffer& encodeBuffer)
{
   /*
      <deviceID>4711</deviceID> 
      { dialingNumber: 4711}
   */
   ASN1T_DeviceID deviceID1;
   deviceID1.t = T_DeviceID_dialingNumber;
   deviceID1.u.dialingNumber = "4711";

   /*
      <DeviceID typeOfNumber="deviceNumber">100</DeviceID> 
       { deviceNumber: 100}
   */
   ASN1T_DeviceID deviceID2;
   deviceID2.t = T_DeviceID_deviceNumber;
   deviceID2.u.deviceNumber = 100;

   /*
     <CallingDeviceID typeOfNumber="explicitPublic:national">18005551212</CallingDeviceID> 
      deviceIdentifier : { explicitPublic : national = 18005551212}
   */
   ASN1T_PublicTON publicTON;
   publicTON.t = T_PublicTON_national;
   publicTON.u.national = "18005551212";

   ASN1T_ExtendedDeviceID extDeviceID3;
   extDeviceID3.t = T_ExtendedDeviceID_explicitPublic;
   extDeviceID3.u.explicitPublic = &publicTON;

   ASN1T_CallingDeviceID callingDeviceID3;
   callingDeviceID3.t = T_CallingDeviceID_deviceIdentifier;
   callingDeviceID3.u.deviceIdentifier = &extDeviceID3;

   /* 
      <CallingDeviceID typeOfNumber="other">abc</CallingDeviceID> 
      deviceIdentifier { other = abc }
   */
   OSOCTET data[] = { 0xAB, 0xC0 };
   ASN1T_OtherPlan other;
   other.numocts = 2;
   other.data = data;

   ASN1T_ExtendedDeviceID extDeviceID4;
   extDeviceID4.t = T_ExtendedDeviceID_other;
   extDeviceID4.u.other = &other;

   ASN1T_CallingDeviceID callingDeviceID4;
   callingDeviceID4.t = T_CallingDeviceID_deviceIdentifier;
   callingDeviceID4.u.deviceIdentifier = &extDeviceID4;

   
   /*
      <CalleddeviceID typeOfNumber="implicitPublic" >123456</CalleddeviceID> 
      
      deviceIdentifier : { implicitPublic = 123456}
   */
   ASN1T_ExtendedDeviceID extDeviceID5;
   extDeviceID5.t = T_ExtendedDeviceID_implicitPublic;
   extDeviceID5.u.implicitPublic = "123456";

   ASN1T_CalledDeviceID calledDeviceID5;
   calledDeviceID5.t = T_CalledDeviceID_deviceIdentifier;
   calledDeviceID5.u.deviceIdentifier = &extDeviceID5;


}

