#include "client.h"

int Client::divertCall (OSRTSocket& cstaSocket)
{
	const OSOCTET* msgptr;
	OSOCTET	msgbuf[MAXMSGLEN];
	int len;

	if (trace) {
		printf ("divert Call \n" );
	}

	/* Initialize the encoding context */
	ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

	/* Encode operation argument */
	if ((len = encodeDivertCallRequest (encodeBuffer)) < 0) { return len; }

	/* Encode ROSE header on top of encoded argument */
	if ((len = encodeROSERequestHeader (encodeBuffer, len, queryDevice_CODE)) < 0) {
		return len;
   }

	msgptr = encodeBuffer.getMsgPtr();

	/* Write the encoded message out to the socket */
	sendMessage (cstaSocket, encodeBuffer, len);
	if (trace) {
		printf ("divert Call msg sent, len = %d \n", len);
	}

	int stat = receiveCSTAMessage (cstaSocket);	
	if (stat != 0) {
		printf ("recvMessage failed, %d \n", stat );
		return stat;
	}
	return len;
}

int Client::encodeDivertCallRequest (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_DivertCallArgument divertCallArgument;
   ASN1C_DivertCallArgument divertCallArgumentC (encodeBuffer, divertCallArgument);
   int len;

   char from[MAX_NUM_SIZE];
   char to[MAX_NUM_SIZE];

   getstring("Device to divert from :", from, sizeof(from));
   getstring("Device to divert to :", to, sizeof(to));
   if (trace) {
	   printf ( "encode divert Call Request, from %s, to %s \n", from, to );
   }

   /* To make it simple, we will omit all of the optional fields */

   /* call to be diverted, first half of divert */
   ASN1T_DeviceID deviceID1;
   deviceID1.t = T_DeviceID_dialingNumber;
   deviceID1.u.dialingNumber = from;

   ASN1T_ConnectionID connectionID;
   connectionID.m.callPresent = 0;
   connectionID.m.devicePresent = 1;
   connectionID.device.t = T_ConnectionID_device_staticID;
   connectionID.device.u.staticID = &deviceID1;

   /* new destination of call, second half of divert */
   ASN1T_DeviceID deviceId2;
   deviceId2.t = T_DeviceID_dialingNumber;
   deviceId2.u.dialingNumber = to;

   ASN1T_ExtendedDeviceID extdeviceId;
   extdeviceId.t = T_ExtendedDeviceID_deviceIdentifier;
   extdeviceId.u.deviceIdentifier = &deviceId2;

   ASN1T_DivertInfo_deflect divertInfo_deflect;
   divertInfo_deflect.callToBeDiverted = connectionID;
   divertInfo_deflect.newDestination.t = T_CalledDeviceID_deviceIdentifier;
   divertInfo_deflect.newDestination.u.deviceIdentifier = &extdeviceId;

   ASN1T_DivertInfo divertInfo;
   divertInfo.t = T_DivertInfo_deflect;
   divertInfo.u.deflect = &divertInfo_deflect;

   divertCallArgument.t = T_DivertCallArgument_divertInfo;
   divertCallArgument.u.divertInfo = &divertInfo;

   /* Encode */

   len = divertCallArgumentC.Encode();

   if (len < 0) {
      printf ("Encode of divertCallArgument failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

void Client::processDivertCallRes(ASN1T_DivertCallResult& divertCallRes)
{
   //TODO: user action for PBX response to divert call
}
