/* This test driver program encodes a data record and writes the        */
/* encoded result to an output file..                                   */

#include <stdio.h>
#include <stdlib.h>

#include "OSRTSocket.h"
#include "client.h"

int main (int argc, char** argv)
{
   int i;
   Client client;
   OSBOOL verbose = FALSE;

   /* Process command line arguments */

   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) verbose = TRUE;
         else if (!strcmp (argv[i], "-notrace")) client.trace = FALSE;
         else {
            printf ("usage: testClient [-notrace]\n");
            printf ("   -notrace    Disable trace information\n" );
            return 0;
         }
      }
   }

   char ipaddr[16];
   client.getstring("IP address of PBX/connecting device: ", ipaddr, 16);

   int port = client.getint("Port number of PBX/connecting device: ");
   printf ("\n");

   /* create socket connection */
   OSRTSocket cstaSocket;
   int socketReturn = cstaSocket.connect (ipaddr, port);
   if (socketReturn < 0) {
      printf ("connect to server socket failed, status = %i \n", socketReturn);
      return -2;
   }

   printf("PBX types: \n");
   printf("---------- \n");
   printf("\t0 - Only CSTA/ACSE message\n");
   printf("\t1 - 2 Length byte + CSTA/ACSE message\n");
   printf("\t2 - Siemens HiCom 300 series\n");
   printf("\t3 - Tadiran CORAL series\n");
   printf("\t4 - Siemens Realitis series\n");
   int pbxtype = client.getint("enter PBX type number: \n");
   if(pbxtype == 0) {
      client.mMessageType = Client::messageonly;
   }
   else if(pbxtype == 1) {
      client.mMessageType = Client::ietf;
   }
   else if(pbxtype == 2) {
      client.mMessageType = Client::siemens_hicom_300;
   }
   else if(pbxtype == 3) {
      client.mMessageType = Client::ietf;
   }
   else if(pbxtype == 4) {
      client.mMessageType = Client::ietf;
   }


   int test = 1;
   while (test) {

      printf("Test actions: \n");
      printf("------------------ \n");
      printf("\t1 - ACSE connection\n");
      printf("\t2 - MakeCall \n");
      printf("\t3 - DivertCall \n");
      printf("\t4 - TranferCall \n");
      printf("\t5 - QueryDevice \n");
      printf("\t6 - AnswerCall \n");
      printf("\t7 - MonitorStart \n");
      printf("\t8 - MonitorStop \n");
      printf("\n\t0 - Quit \n");

      test = client.getint("enter action number: \n");

      switch(test) {
         case 1: /* ACSE association */ {
            client.connect(cstaSocket);
         }   
         break;
      
         case 2: /* MakeCall */ {
            client.makeCall(cstaSocket);
         }
         break;

         case 3: /* DivertCall */ {
            client.divertCall(cstaSocket);
         }
         break;

         case 4: /* TranferCall */ {
            client.transferCall(cstaSocket);
         }
         break;

         case 5: /* QueryDevice */ {
            client.queryDevice(cstaSocket);
         }
         break;

         case 6: /* AnswerCall */ {
            client.answerCall(cstaSocket);
         }
         break;

         case 7: /* MonitorStart */ {
            client.monitorStart(cstaSocket);
         }
         break;

         case 8: /* MonitorStop */ {
            client.monitorStop(cstaSocket);
         }
         break;

         case 0: { //end of calls
            client.release(cstaSocket);
         }
         break;

         default: {
            printf("Bad action requested !\n");
         }
         break;
      } // switch
   }   //for

   return 0;
}

/* get input helper functions */

/* Get a string from command line */
void Client::getstring(char *prompt, char *buf, int size)
{
   printf("%s", prompt);
   fflush(stdout);

   fgets(buf, size, stdin);

   if (buf[strlen(buf) - 1] == '\n')
      buf[strlen(buf) - 1] = '\0';
}

/* Get an integer from command line */
int Client::getint(char *prompt)
{
   int val = 0;
   char buf[32];

   printf("%s", prompt);
   fflush(stdout);

   fgets(buf, sizeof(buf), stdin);
   sscanf(buf, "%d", &val);

   return(val);
}

/* Get an hexa number from command line */
int Client::gethex(char *prompt)
{
   int val = 0;
   char buf[32];

   printf("%s", prompt);
   fflush(stdout);

   fgets(buf, sizeof(buf), stdin);
   sscanf(buf, "%x", &val);

   return(val);
}


