#include "client.h"


int Client::connect(OSRTSocket& cstaSocket)
{
   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int len;

   if (init(cstaSocket) < 0) return -1;

   if (trace) {
      printf ("ACSE association \n" );
   }

   /* Initialize the encoding context */
   ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

   /* Encode operation argument */
   if ((len = encodeACSEConnectionRequest (encodeBuffer)) < 0) {
      return len;
   }

   msgptr = encodeBuffer.getMsgPtr();

   /* Write the encoded message out to the socket */
   sendMessage (cstaSocket, encodeBuffer, len);
   if (trace) {
      printf ("ACSE associate msg sent, len = %d \n", len);
   }

   int stat = receiveACSEMessage (cstaSocket);	
   if (stat != 0) {
      printf ("error: receive message failed, %d \n", stat );
      return stat;
   }
   return 0;
}

int Client::encodeACSEConnectionRequest (ASN1BEREncodeBuffer& encodeBuffer)
{ 
   if (trace) {
	   printf ("encode ACSE Connection Request\n" );
   }

   ASN1T_AARQ_apdu aarq_apdu;
   int len;

   ASN1OBJID oidAppContName = { 5, {1, 3, 12, 0, 180 } };
   ASN1OBJID oidCsta2AppContName = { 6, {1, 3, 12, 0, 218, 200 } };
   aarq_apdu.aSO_context_name = oidAppContName;

   /* Populate aarq_apdu.user_information */
   aarq_apdu.m.user_informationPresent = 1;
   ASN1T_ACSEUserInformationForCSTA acseuserinfo;
   acseuserinfo.cSTAVersion.numbits = 5;
   acseuserinfo.cSTAVersion.data[0] = 0x40; //version 2

   ASN1BEREncodeBuffer userInfoEncodeBuffer;//using dynamic buffer of context
   ASN1C_ACSEUserInformationForCSTA opentypeC(userInfoEncodeBuffer, acseuserinfo);
   if((len = opentypeC.Encode()) < 0) {
      printf("Encode of ACSEUserInformationForCSTA failed\n");
      userInfoEncodeBuffer.printErrorInfo();
   }
   ASN1TOpenType single_ASN1_type;
   single_ASN1_type.numocts = len;
   single_ASN1_type.data = userInfoEncodeBuffer.getMsgPtr();

   ASN1T_External user_information_elem;
   user_information_elem.encoding.t = T_External_encoding_single_ASN1_type;
   user_information_elem.encoding.u.single_ASN1_type = &single_ASN1_type;

   user_information_elem.m.direct_referencePresent = 1;
   user_information_elem.direct_reference = oidCsta2AppContName;

   //add Associate-data to list aarq_apdu.user_information
   ASN1C_Association_data user_informationC(aarq_apdu.user_information);
   user_informationC.Append(&user_information_elem);

   ASN1T_ACSE_apdu acse_apdu;
   acse_apdu.t = T_ACSE_apdu_aarq;
   acse_apdu.u.aarq = &aarq_apdu;

   ASN1C_ACSE_apdu pdu(encodeBuffer, acse_apdu);

   len = pdu.Encode();

   if (len < 0) {
      printf ("Encode of ACSE pdu failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}


/* cleanup Handler */
int Client::release(OSRTSocket& cstaSocket)
{
   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int len;

   if (trace) {
      printf ("ACSE release \n" );
   }

   /* Initialize the encoding context */
   ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

   /* Encode operation argument */
   if ((len = encodeACSEReleaseRequest (encodeBuffer)) < 0) {
      return len;
   }

   msgptr = encodeBuffer.getMsgPtr();

   /* Write the encoded message out to the socket */
   sendMessage (cstaSocket, encodeBuffer, len);
   if (trace) {
      printf ("ACSE release msg sent, len = %d \n", len);
   }

   int stat = receiveACSEMessage (cstaSocket);	
   if (stat != 0) {
      printf ("recvMessage failed, %d \n", stat );
      return stat;
   }
   return 0;
}

/* Encode ACSE connection Release Request 

The ACSE_apdu.rlrq(request) is transmitted and the CSTA Application 
waits for an ACSE_apdu.rlre(response). If a response is 
received then the connection is released for CSTA Applications.

*/
int Client::encodeACSEReleaseRequest (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_RLRQ_apdu rlrq_apdu;
   int len;

   if (trace) {
	   printf ("encode ACSE Release Request\n" );
   }

   rlrq_apdu.m.reasonPresent = 1;
   rlrq_apdu.reason = Release_request_reason::normal;

   /* All other optional fields are ignored for simplicity. */

   /* Encode */
   ASN1T_ACSE_apdu acse_apdu;
   acse_apdu.t = T_ACSE_apdu_rlrq;
   acse_apdu.u.rlrq = &rlrq_apdu;

   ASN1C_ACSE_apdu pdu(encodeBuffer, acse_apdu);

   len = pdu.Encode();

   if (len < 0) {
      printf ("Encode ACSE PDU failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

/* Encode ACSE connection abort, this is not a Request */

int Client::encodeACSEAbort (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_ABRT_apdu abrt_apdu;
   int len;

   if (trace) {
	   printf ("encode ACSE Abort\n" );
   }

   abrt_apdu.abort_source = ABRT_source::acse_service_user;

   /* All other optional fields are ignored for simplicity. */

   /* Encode */
   ASN1T_ACSE_apdu acse_apdu;
   acse_apdu.t = T_ACSE_apdu_abrt;
   acse_apdu.u.abrt = &abrt_apdu;

   ASN1C_ACSE_apdu pdu(encodeBuffer, acse_apdu);

   len = pdu.Encode();

   if (len < 0) {
      printf ("Encode ACSE PDU failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

int Client::receiveACSEMessage(OSRTSocket& cstaSocket)
{
   ASN1BERDecodeBuffer decodeBuffer;
   if(receiveMessage(cstaSocket, decodeBuffer) < 0) {
      printf("error: failed to receive message\n");
      return -1;
   }

   ASN1T_ACSE_apdu pdu;
   ASN1C_ACSE_apdu pduC (decodeBuffer, pdu);

   int stat = pduC.Decode ();

   if (stat == 0) {
      if (trace) {
         printf ("Decode of ACSE PDU was successful\n");
         pduC.Print ("pdu");
      }
   }
   else {
      printf ("Decode of ACSE PDU failed\n");
      decodeBuffer.printErrorInfo ();
      return -1;
   }

   /* Process the ACSE operation */
   //processACSEPDU (pdu, trace);
   printf ("***\n");

   return 0;
}
