#include "client.h"

int Client::makeCall(OSRTSocket& cstaSocket)
{
   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int len;

   if (trace) {
      printf ("Make Call \n" );
   }

   /* Initialize the encoding context */

   ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

   /* Encode operation argument */

   if ((len = encodeMakeCallRequest (encodeBuffer)) < 0) return len;

   /* Encode ROSE header on top of encoded argument */
   if ((len = encodeROSERequestHeader (encodeBuffer, len, makeCall_CODE)) < 0) return len;

   msgptr = encodeBuffer.getMsgPtr();

   /* Write the encoded message out to the socket */

   sendMessage (cstaSocket, encodeBuffer, len);
   if (trace) {
      printf ("Make Call msg sent, len = %d \n", len);
   }

   int stat = receiveCSTAMessage (cstaSocket);	
   if (stat != 0) {
      printf ("recvMessage failed, %d \n", stat );
      return stat;
   }

   return 0;
}

int Client::encodeMakeCallRequest(ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_MakeCallArgument makeCallArgument;
   ASN1C_MakeCallArgument makeCallArgumentC (encodeBuffer, makeCallArgument);
   int len;

   char from[MAX_NUM_SIZE];
   char to[MAX_NUM_SIZE];

   getstring("Calling device :", from, sizeof(from));
   getstring("Called device :", to, sizeof(to));

   if (trace) {
	   printf ( "encode Make Call Request, from %s, to %s \n", from, to );
   }

   /* To make it simple, we will omit all of the optional fields */

   makeCallArgument.callingDevice.t = T_DeviceID_dialingNumber;
   makeCallArgument.callingDevice.u.dialingNumber = from;

   ASN1T_DeviceID deviceId;
   deviceId.t = T_DeviceID_dialingNumber;
   deviceId.u.dialingNumber = to;

   ASN1T_ExtendedDeviceID extdeviceId;
   extdeviceId.t = T_ExtendedDeviceID_deviceIdentifier;
   extdeviceId.u.deviceIdentifier = &deviceId;

   makeCallArgument.calledDirectoryNumber.t = T_CalledDeviceID_deviceIdentifier;
   makeCallArgument.calledDirectoryNumber.u.deviceIdentifier = &extdeviceId; 

   /* Encode */

   len = makeCallArgumentC.Encode();

   if (len < 0) {
      printf ("Encode of MakeCallArgument failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

void Client::processMakeCallResult(ASN1T_MakeCallResult& makeCallRes)
{
   //TODO: user action for PBX response to make call
}
