#include "client.h"

int Client::monitorStop(OSRTSocket& cstaSocket)
{
	const OSOCTET* msgptr;
	OSOCTET	msgbuf[MAXMSGLEN];
	int len;

	if (trace) {
		printf ("Monitor Stop \n" );
	}

	/* Initialize the encoding context */
	ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

	/* Encode operation argument */
	if ((len = encodeMonitorStopRequest (encodeBuffer)) < 0) 
		return len;

	/* Encode ROSE header on top of encoded argument */
	if ((len = encodeROSERequestHeader (encodeBuffer, len, monitorStop_CODE)) < 0) 
		return len;

	msgptr = encodeBuffer.getMsgPtr();

	/* Write the encoded message out to the socket */

	sendMessage (cstaSocket, encodeBuffer, len);
	if (trace) {
		printf ("monitor stop message sent, len = %d \n", len);
	}

	int stat = receiveCSTAMessage (cstaSocket);
	if (stat != 0) {
		printf ("recvMessage failed, %d \n", stat );
		return stat;
	}
	return 0;
}

int Client::encodeMonitorStopRequest (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_MonitorStopArgument monStopArgument;
   ASN1C_MonitorStopArgument 
      monStopArgumentC (encodeBuffer, monStopArgument);
   int len;

   /* get data from user */
   unsigned int Ref;
   char crossRefId[MAX_NUM_SIZE];
   Ref = gethex("Monitor's crossRefID :");
   if (Ref > 255) {
      crossRefId[0] = (char) ((Ref >> 8) & 0x00ff);
          crossRefId[1] = (char) (Ref & 0x00ff);
          crossRefId[2] = '\0';
   } 
   else {
      crossRefId[0] = (char) (Ref & 0x00ff);
          crossRefId[1] = '\0';
   }
   if (trace) {
       printf ("encode Monitor Stop Request, ref id %x \n", *crossRefId );
   }

   /* To make it simple, we will omit all of the optional fields */

   monStopArgument.t = T_MonitorStopArgument_crossRefIdentifier;

   OSOCTET data[MAX_NUM_SIZE];
   strcpy ((char*)data, crossRefId);

   ASN1TDynOctStr refData;
   refData.data = data;
   refData.numocts = strlen(crossRefId);

   monStopArgument.u.crossRefIdentifier = &refData; 

   /* Encode */

   len = monStopArgumentC.Encode();

   if (len < 0) {
      printf ("Encode of MonitorStopArgument failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

void Client::processMonitorStopRes(ASN1T_MonitorStopResult& monitorStopRes)
{
   //TODO: user action for PBX response to MonitorStop
}
