/* This test driver program encodes a data record and writes the        */
/* encoded result to an output file..                                   */

#include <stdio.h>
#include <stdlib.h>
#include "CSTA-ROSE-PDU-types.h"
#include "CSTA-answer-call.h"

#define MAXMSGLEN 1024

static int encodeAnswerCallResponse (ASN1BEREncodeBuffer& encodeBuffer);

static int encodeROSEResponseHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen);

int main (int argc, char** argv)
{
   /* Run-time support variables */

   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int		i, len;
   FILE*        fp;
   char*        filename = "message.dat";
   OSBOOL     trace = TRUE;
OSBOOL verbose = FALSE;

   /* Process command line arguments */

   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) verbose = TRUE;
         else if (!strcmp (argv[i], "-o")) filename = argv[++i];
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: writer [ -v ] [ -o <filename>\n");
            printf ("   -v  verbose mode: print trace info\n");
            printf ("   -o <filename>  write encoded msg to <filename>\n");
            printf ("   -notrace  do not display trace info\n");
            return 0;
         }
      }
   }


      /* Initialize the encoding context */

      ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

      /* Encode operation argument */

      if ((len = encodeAnswerCallResponse (encodeBuffer)) < 0) return len;

      /* Encode ROSE header on top of encoded argument */

      if ((len = encodeROSEResponseHeader (encodeBuffer, len)) < 0) return len;

      msgptr = encodeBuffer.getMsgPtr();

      if (trace) {
         encodeBuffer.binDump();
      }

      /* Write the encoded message out to the output file */

      if (fp = fopen (filename, "wb")) {
         fwrite (msgptr, 1, len, fp);
         fclose (fp);
      }
      else {
         printf ("Error opening %s for write access\n", filename);
         return -1;
      }

   return 0;

}

/* Encode "AnswerCall" operation Response */

static int encodeAnswerCallResponse (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_AnswerCallResult answerCallRes;
   ASN1C_AnswerCallResult answerCallResC(encodeBuffer, answerCallRes);
   int len;

   /* To make it simple, we will omit all of the optional fields */

   answerCallRes.t = T_AnswerCallResult_noData;

   /* Encode */

   len = answerCallResC.Encode();

   if (len < 0) {
      printf ("Encode of AnswerCallResult failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

/* Encode ROSE header */

static int encodeROSEResponseHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen)
{
   ASN1T_CSTA_ROSE_PDU pdu;
   ASN1C_CSTA_ROSE_PDU pduC (encodeBuffer, pdu);
   ASN1T_ReturnResult returnResult;
   int len;

   /* Populate header structure */

   returnResult.m.resultPresent = 1;
   returnResult.invokeId.t = T_InvokeId_present;
   returnResult.invokeId.u.present = 1; /* arbitrary number: should be unique */
   returnResult.result.opcode.t = T_Code_local;
   returnResult.result.opcode.u.local = 2;   /* opeartion code for "answerCall" operation from Table 1 */

   /* This is where we get the previously encoded message component..   */
   returnResult.result.result.numocts = msglen;
   returnResult.result.result.data = (OSOCTET*) encodeBuffer.getMsgPtr();

   pdu.t = T_CSTA_ROSE_PDU_returnResult;
   pdu.u.returnResult = &returnResult;

   /* Encode */

   len = pduC.Encode();

   if (len < 0) {
      printf ("Encode ROSE PDU failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}
