/* This test driver program encodes a data record and writes the        */
/* encoded result to an output file..                                   */

#include <stdio.h>
#include <stdlib.h>
#include "CSTA-ROSE-PDU-types.h"
#include "CSTA-event-report-definitions.h"
#include "CSTA-conferenced-event.h"

#define MAXMSGLEN 1024

static int encodeConferencedEvent (ASN1BEREncodeBuffer& encodeBuffer);

static int encodeROSEInvokeHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen);

int main (int argc, char** argv)
{
   /* Run-time support variables */

   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int		i, len;
   FILE*        fp;
   char*        filename = "message.dat";
   OSBOOL     trace = TRUE;
OSBOOL verbose = FALSE;

   /* Process command line arguments */

   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) verbose = TRUE;
         else if (!strcmp (argv[i], "-o")) filename = argv[++i];
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: writer [ -v ] [ -o <filename>\n");
            printf ("   -v  verbose mode: print trace info\n");
            printf ("   -o <filename>  write encoded msg to <filename>\n");
            printf ("   -notrace  do not display trace info\n");
            return 0;
         }
      }
   }


      /* Initialize the encoding context */

      ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

      /* Encode event info */

      if ((len = encodeConferencedEvent (encodeBuffer)) < 0) return len;

      /* Encode ROSE header on top of encoded argument */

      if ((len = encodeROSEInvokeHeader (encodeBuffer, len)) < 0) return len;

      msgptr = encodeBuffer.getMsgPtr();

      if (trace) {
         encodeBuffer.binDump();
      }

      /* Write the encoded message out to the output file */

      if (fp = fopen (filename, "wb")) {
         fwrite (msgptr, 1, len, fp);
         fclose (fp);
      }
      else {
         printf ("Error opening %s for write access\n", filename);
         return -1;
      }

   return 0;

}

/* Encode "Conferenced" event for "cSTAEventReport" operation */

static int encodeConferencedEvent (ASN1BEREncodeBuffer& encodeBuffer)
{
   /* To make it simple, we will omit all of the optional fields */
   ASN1T_ConferencedEvent conferenced;

   /* ConferencedEvent.primaryOldCall */
   ASN1T_DeviceID staticID;
   staticID.t = T_DeviceID_dialingNumber;
   staticID.u.dialingNumber = "22343";

   conferenced.primaryOldCall.m.callPresent = 1;
   conferenced.primaryOldCall.m.devicePresent = 1;
   OSOCTET data[] = { 0x10 };
   conferenced.primaryOldCall.call.numocts = 1;
   conferenced.primaryOldCall.call.data = data;
   conferenced.primaryOldCall.device.t = T_ConnectionID_device_staticID;
   conferenced.primaryOldCall.device.u.staticID = &staticID;

   /* ConferencedEvent.confController */
   ASN1T_DeviceID deviceId1;
   deviceId1.t = T_DeviceID_dialingNumber;
   deviceId1.u.dialingNumber = "22343";

   ASN1T_ExtendedDeviceID extdeviceId1;
   extdeviceId1.t = T_ExtendedDeviceID_deviceIdentifier;
   extdeviceId1.u.deviceIdentifier = &deviceId1;

   conferenced.confController.t = T_SubjectDeviceID_deviceIdentifier;
   conferenced.confController.u.deviceIdentifier = &extdeviceId1;

   /* ConferencedEvent.addedParty */
   ASN1T_DeviceID deviceId2;
   deviceId2.t = T_DeviceID_dialingNumber;
   deviceId2.u.dialingNumber = "55555";

   ASN1T_ExtendedDeviceID extdeviceId2;
   extdeviceId2.t = T_ExtendedDeviceID_deviceIdentifier;
   extdeviceId2.u.deviceIdentifier = &deviceId2;

   conferenced.addedParty.t = T_SubjectDeviceID_deviceIdentifier;
   conferenced.addedParty.u.deviceIdentifier = &extdeviceId2; 

   conferenced.m.conferenceConnectionsPresent = 1;

   /* ConferencedEvent.conferenceConnections.element 1 */
   ASN1T_ConnectionID connid1;
   ASN1T_ConnectionList_element elem1;
   elem1.t = T_ConnectionList_element_newConnectionOnly;
   elem1.u.newConnectionOnly = &connid1;
    
   ASN1T_DeviceID elem1_staticID;
   elem1_staticID.t = T_DeviceID_dialingNumber;
   elem1_staticID.u.dialingNumber = "22343";

   connid1.m.callPresent = 1;
   connid1.m.devicePresent = 1;
   OSOCTET elem1_data1[] = { 0x10 };
   connid1.call.numocts = 1;
   connid1.call.data = elem1_data1;
   connid1.device.t = T_ConnectionID_device_staticID;
   connid1.device.u.staticID = &elem1_staticID;

   rtxDListAppend(encodeBuffer.getCtxtPtr(), &conferenced.conferenceConnections, &elem1);

   /* ConferencedEvent.ConnectionList element 2 */
   ASN1T_ConnectionID connid2;
   ASN1T_ConnectionList_element elem2;
   elem2.t = T_ConnectionList_element_newConnectionOnly;
   elem2.u.newConnectionOnly = &connid2;
    
   ASN1T_DeviceID elem2_staticID;
   elem2_staticID.t = T_DeviceID_dialingNumber;
   elem2_staticID.u.dialingNumber = "33333";

   connid2.m.callPresent = 1;
   connid2.m.devicePresent = 1;
   OSOCTET elem2_data1[] = { 0x10 };
   connid2.call.numocts = 1;
   connid2.call.data = elem2_data1;
   connid2.device.t = T_ConnectionID_device_staticID;
   connid2.device.u.staticID = &elem2_staticID;

   rtxDListAppend(encodeBuffer.getCtxtPtr(), &conferenced.conferenceConnections, &elem2);

   /* ConferencedEvent.ConnectionList element 3 */
   ASN1T_ConnectionID connid3;
   ASN1T_ConnectionList_element elem3;
   elem3.t = T_ConnectionList_element_newConnectionOnly;
   elem3.u.newConnectionOnly = &connid3;
    
   ASN1T_DeviceID elem3_staticID;
   elem3_staticID.t = T_DeviceID_dialingNumber;
   elem3_staticID.u.dialingNumber = "55555";

   connid3.m.callPresent = 1;
   connid3.m.devicePresent = 1;
   OSOCTET elem3_data1[] = { 0x10 };
   connid3.call.numocts = 1;
   connid3.call.data = elem3_data1;
   connid3.device.t = T_ConnectionID_device_staticID;
   connid3.device.u.staticID = &elem3_staticID;

   rtxDListAppend(encodeBuffer.getCtxtPtr(), &conferenced.conferenceConnections, &elem3);

   /* end of ConferencedEvent.ConnectionList element append */

   /* ConferencedEvent.cause */
   conferenced.m.causePresent = 1;
   conferenced.cause = EventCause::keyOperation;

   ASN1T_CallEvent callevent;
   callevent.t = T_CallEvent_conferencedEvent;
   callevent.u.conferencedEvent = &conferenced;

   ASN1T_CSTAEventReportArgument eventReportArg;
   ASN1C_CSTAEventReportArgument eventReportArgC(encodeBuffer, eventReportArg);
   int len;

   /* CSTAEventReportArgument */
   OSOCTET data2[] = { 0x99 };
   eventReportArg.crossRefIdentifier.numocts = 1;
   eventReportArg.crossRefIdentifier.data = data2;
   eventReportArg.eventSpecificInfo.t = T_EventSpecificInfo_callEvent;
   eventReportArg.eventSpecificInfo.u.callEvent = &callevent;

   /* Encode */

   len = eventReportArgC.Encode();

   if (len < 0) {
      printf ("Encode of CSTAEventReportArgument failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

/* Encode ROSE header */

static int encodeROSEInvokeHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen)
{
   ASN1T_CSTA_ROSE_PDU pdu;
   ASN1C_CSTA_ROSE_PDU pduC (encodeBuffer, pdu);
   ASN1T_CSTA_ROSE_PDU_invoke invoke;
   int len;

   /* Populate header structure */

   invoke.m.argumentPresent = 1;
   invoke.invokeId.t = T_InvokeId_present;
   invoke.invokeId.u.present = 1; /* arbitrary number: should be unique */
   invoke.opcode.t = T_Code_local;
   invoke.opcode.u.local = 21;   /* opeartion code for "cSTAEventReport" operation from Table 1 */

   /* This is where we get the previously encoded message component..   */
   invoke.argument.numocts = msglen;
   invoke.argument.data = (OSOCTET*) encodeBuffer.getMsgPtr();

   pdu.t = T_CSTA_ROSE_PDU_invoke;
   pdu.u.invoke = &invoke;

   /* Encode */

   len = pduC.Encode();

   if (len < 0) {
      printf ("Encode ROSE PDU failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}
