/* This test driver program encodes a data record and writes the        */
/* encoded result to an output file..                                   */

#include <stdio.h>
#include <stdlib.h>
#include "CSTA-ROSE-PDU-types.h"
#include "CSTA-event-report-definitions.h"
#include "CSTA-delivered-event.h"

#define MAXMSGLEN 1024

static int encodeDeliveredEvent (ASN1BEREncodeBuffer& encodeBuffer);

static int encodeROSEInvokeHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen);

int main (int argc, char** argv)
{
   /* Run-time support variables */

   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int		i, len;
   FILE*        fp;
   char*        filename = "message.dat";
   OSBOOL     trace = TRUE;
OSBOOL verbose = FALSE;

   /* Process command line arguments */

   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) verbose = TRUE;
         else if (!strcmp (argv[i], "-o")) filename = argv[++i];
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: writer [ -v ] [ -o <filename>\n");
            printf ("   -v  verbose mode: print trace info\n");
            printf ("   -o <filename>  write encoded msg to <filename>\n");
            printf ("   -notrace  do not display trace info\n");
            return 0;
         }
      }
   }


      /* Initialize the encoding context */

      ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

      /* Encode event info */

      if ((len = encodeDeliveredEvent (encodeBuffer)) < 0) return len;

      /* Encode ROSE header on top of encoded argument */

      if ((len = encodeROSEInvokeHeader (encodeBuffer, len)) < 0) return len;

      msgptr = encodeBuffer.getMsgPtr();

      if (trace) {
         encodeBuffer.binDump();
      }

      /* Write the encoded message out to the output file */

      if (fp = fopen (filename, "wb")) {
         fwrite (msgptr, 1, len, fp);
         fclose (fp);
      }
      else {
         printf ("Error opening %s for write access\n", filename);
         return -1;
      }

   return 0;

}

/* Encode "delivered" event for "cSTAEventReport" operation */

static int encodeDeliveredEvent (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_DeliveredEvent delivered;

   /* To make it simple, we will omit all of the optional fields */

   /* DeliveredEventInfo.connection */
   ASN1T_DeviceID staticID;
   staticID.t = T_DeviceID_dialingNumber;
   staticID.u.dialingNumber = "023";

   delivered.connection.m.callPresent = 1;
   delivered.connection.m.devicePresent = 1;
   OSOCTET data[] = { 0x20 };
   delivered.connection.call.numocts = 1;
   delivered.connection.call.data = data;
   delivered.connection.device.t = T_ConnectionID_device_staticID;
   delivered.connection.device.u.staticID = &staticID;

   /* DeliveredEventInfo.alertingDevice */
   ASN1T_DeviceID deviceId2;
   deviceId2.t = T_DeviceID_dialingNumber;
   deviceId2.u.dialingNumber = "18005551212";

   ASN1T_ExtendedDeviceID extdeviceId2;
   extdeviceId2.t = T_ExtendedDeviceID_deviceIdentifier;
   extdeviceId2.u.deviceIdentifier = &deviceId2;

   delivered.alertingDevice.t = T_SubjectDeviceID_deviceIdentifier;
   delivered.alertingDevice.u.deviceIdentifier = &extdeviceId2; 

   /* DeliveredEventInfo.callingDevice */
   ASN1T_DeviceID deviceId3;
   deviceId3.t = T_DeviceID_dialingNumber;
   deviceId3.u.dialingNumber = "22343";

   ASN1T_ExtendedDeviceID extdeviceId3;
   extdeviceId3.t = T_ExtendedDeviceID_deviceIdentifier;
   extdeviceId3.u.deviceIdentifier = &deviceId3;

   delivered.callingDevice.t = T_CallingDeviceID_deviceIdentifier;
   delivered.callingDevice.u.deviceIdentifier = &extdeviceId3; 

   /* DeliveredEventInfo.calledDevice */
   ASN1T_DeviceID deviceId4;
   deviceId4.t = T_DeviceID_dialingNumber;
   deviceId4.u.dialingNumber = "18005551212";

   ASN1T_ExtendedDeviceID extdeviceId4;
   extdeviceId4.t = T_ExtendedDeviceID_deviceIdentifier;
   extdeviceId4.u.deviceIdentifier = &deviceId4;

   delivered.calledDevice.t = T_CalledDeviceID_deviceIdentifier;
   delivered.calledDevice.u.deviceIdentifier = &extdeviceId4; 

   delivered.lastRedirectionDevice.t = T_RedirectionDeviceID_notRequired;
   delivered.m.localConnectionInfoPresent = 1;
   delivered.localConnectionInfo = LocalConnectionState::alerting;
   delivered.m.causePresent = 1;
   delivered.cause = EventCause::newCall;

   delivered.lastRedirectionDevice.t = T_RedirectionDeviceID_notRequired;
   delivered.m.localConnectionInfoPresent = 1;
   delivered.localConnectionInfo = LocalConnectionState::alerting;
   delivered.cause = EventCause::networkCongestion;

   ASN1T_CallEvent callevent;
   callevent.t = T_CallEvent_deliveredEvent;
   callevent.u.deliveredEvent = &delivered;

   ASN1T_CSTAEventReportArgument eventReportArg;
   ASN1C_CSTAEventReportArgument eventReportArgC(encodeBuffer, eventReportArg);
   int len;

   /* CSTAEventReportArgument */
   OSOCTET data2[] = { 0x99 };
   eventReportArg.crossRefIdentifier.numocts = 1;
   eventReportArg.crossRefIdentifier.data = data2;
   eventReportArg.eventSpecificInfo.t = T_EventSpecificInfo_callEvent;
   eventReportArg.eventSpecificInfo.u.callEvent = &callevent;

   /* Encode */

   len = eventReportArgC.Encode();

   if (len < 0) {
      printf ("Encode of CSTAEventReportArgument failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

/* Encode ROSE header */

static int encodeROSEInvokeHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen)
{
   ASN1T_CSTA_ROSE_PDU pdu;
   ASN1C_CSTA_ROSE_PDU pduC (encodeBuffer, pdu);
   ASN1T_CSTA_ROSE_PDU_invoke invoke;
   int len;

   /* Populate header structure */

   invoke.m.argumentPresent = 1;
   invoke.invokeId.t = T_InvokeId_present;
   invoke.invokeId.u.present = 1; /* arbitrary number: should be unique */
   invoke.opcode.t = T_Code_local;
   invoke.opcode.u.local = 21;   /* opeartion code for "cSTAEventReport" operation from Table 1 */

   /* This is where we get the previously encoded message component..   */
   invoke.argument.numocts = msglen;
   invoke.argument.data = (OSOCTET*) encodeBuffer.getMsgPtr();

   pdu.t = T_CSTA_ROSE_PDU_invoke;
   pdu.u.invoke = &invoke;

   /* Encode */

   len = pduC.Encode();

   if (len < 0) {
      printf ("Encode ROSE PDU failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}
