// This test driver decodes and prints an encoded CSTAEventReportArgument 
// and prints the result..

#include "CSTA-ROSE-PDU-types.h"
#include "CSTA-event-report-definitions.h"
#include "CSTA-extend.h"

int main (int argc, char** argv)
{
   int stat;
   const OSOCTET message[] = {
      0xA1, 0x50, 0x02, 0x02, 0x32, 0x0A, 0x02, 0x01,
      0x15, 0x30, 0x47, 0x55, 0x04, 0x01, 0x36, 0xB3,
      0x00, 0xA0, 0x16, 0xAC, 0x14, 0x30, 0x12, 0x6B,
      0x0A, 0x82, 0x02, 0x00, 0x31, 0x83, 0x04, 0x04,
      0x61, 0x01, 0x00, 0x4E, 0x01, 0x01, 0x0A, 0x01,
      0x16, 0x7E, 0x27, 0xA0, 0x0F, 0x17, 0x0D, 0x30,
      0x39, 0x30, 0x37, 0x32, 0x33, 0x31, 0x31, 0x33,
      0x39, 0x32, 0x38, 0x5A, 0xA1, 0x14, 0x30, 0x12,
      0x06, 0x06, 0x2B, 0x0C, 0x89, 0x36, 0x84, 0x09,
      0x04, 0x08, 0xA8, 0x0C, 0x68, 0x4A, 0x31, 0x00,
      0x01, 0x00
   } ;

   /* Decode ROSE header */

   ASN1BERDecodeBuffer decodeBuffer (message, sizeof(message));
   ASN1T_CSTA_ROSE_PDU pdu;
   ASN1C_CSTA_ROSE_PDU pduC (decodeBuffer, pdu);

   stat = pduC.Decode ();

   if (stat == 0) {
      printf ("Decode of ROSE PDU was successful\n");
      pduC.Print ("pdu");
   }
   else {
      printf ("Decode of ROSE PDU failed\n");
      decodeBuffer.printErrorInfo ();
      return -1;
   }

   /* Decode CSTA Event Report Argument */

   ASN1BERDecodeBuffer decodeBuffer2 
      (pdu.u.invoke->argument.data, pdu.u.invoke->argument.numocts);

   ASN1T_CSTAEventReportArgument eventReportArg;
   ASN1C_CSTAEventReportArgument eventReportArgC (decodeBuffer2, eventReportArg);

   stat = eventReportArgC.Decode();

   if (stat == 0) {
      printf ("Decode of CSTAEventReportArgument was successful\n");
      eventReportArgC.Print ("eventReportArg");
   }
   else {
      printf ("Decode of CSTAEventReportArgument failed\n");
      decodeBuffer2.printErrorInfo ();
      return -1;
   }

   /* Decode Alcatel CSTA private data */

   ASN1T_CSTA_extension_types_CSTAPrivateData* pEncPrivateData =
      (ASN1T_CSTA_extension_types_CSTAPrivateData*)
      eventReportArg.extensions.privateData.head->data;

   ASN1BERDecodeBuffer decodeBuffer3 
      (pEncPrivateData->data, pEncPrivateData->numocts);
   ASN1T_AlcatelCSTAPrivateData privateData;
   ASN1C_AlcatelCSTAPrivateData privateDataC (decodeBuffer3, privateData);

   stat = privateDataC.Decode();

   if (stat == 0) {
      printf ("Decode of AlcatelCSTAPrivateData was successful\n");
      privateDataC.Print ("privateData");
   }
   else {
      printf ("Decode of AlcatelCSTAPrivateData failed\n");
      decodeBuffer3.printErrorInfo ();
      return -1;
   }

   /* Must now match OID with events documented in Alcatel manual */

   if ((const ASN1OBJID)privateData.manufacturer == 
       (const ASN1OBJID)globalCallId) {
      ASN1BERDecodeBuffer decodeBuffer4 
         (privateData.aOpenType.data, privateData.aOpenType.numocts);
      ASN1T_GlobalCallId globalCallId;
      ASN1C_GlobalCallId 
         globalCallIdC (decodeBuffer4, globalCallId);

      stat = globalCallIdC.Decode();

      if (stat == 0) {
         printf ("Decode of GlobalCallId was successful\n");
         globalCallIdC.Print ("globalCallId");
      }
      else {
         printf ("Decode of GlobalCallId failed\n");
         decodeBuffer4.printErrorInfo ();
         return -1;
      }
   }
   // other cases here

   return 0;
}
