/* This test driver program encodes a data record and writes the        */
/* encoded result to an output file..                                   */

#include <stdio.h>
#include <stdlib.h>
#include "CSTA-ROSE-PDU-types.h"
#include "CSTA-make-call.h"

#define MAXMSGLEN 1024

static int encodeMakeCallResponse (ASN1BEREncodeBuffer& encodeBuffer);

static int encodeROSEResponseHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen);

int main (int argc, char** argv)
{
   /* Run-time support variables */

   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int		i, len;
   FILE*        fp;
   char*        filename = "message.dat";
   OSBOOL     trace = TRUE;
OSBOOL verbose = FALSE;

   /* Process command line arguments */

   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) verbose = TRUE;
         else if (!strcmp (argv[i], "-o")) filename = argv[++i];
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: writer [ -v ] [ -o <filename>\n");
            printf ("   -v  verbose mode: print trace info\n");
            printf ("   -o <filename>  write encoded msg to <filename>\n");
            printf ("   -notrace  do not display trace info\n");
            return 0;
         }
      }
   }


      /* Initialize the encoding context */

      ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

      /* Encode operation argument */

      if ((len = encodeMakeCallResponse (encodeBuffer)) < 0) return len;

      /* Encode ROSE header on top of encoded argument */

      if ((len = encodeROSEResponseHeader (encodeBuffer, len)) < 0) return len;

      msgptr = encodeBuffer.getMsgPtr();

      if (trace) {
         encodeBuffer.binDump();
      }

      /* Write the encoded message out to the output file */

      if (fp = fopen (filename, "wb")) {
         fwrite (msgptr, 1, len, fp);
         fclose (fp);
      }
      else {
         printf ("Error opening %s for write access\n", filename);
         return -1;
      }

   return 0;

}

/* Encode "makeCall" operation response */

static int encodeMakeCallResponse (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_MakeCallResult makeCallResult;
   ASN1C_MakeCallResult makeCallResultC (encodeBuffer, makeCallResult);
   int len;

   /* Set ConnectionID option */

   ASN1T_DeviceID staticID;
   staticID.t = T_DeviceID_dialingNumber;
   staticID.u.dialingNumber = "22343";

   ASN1T_ConnectionID connectionId;
   connectionId.m.callPresent = 1;
   connectionId.m.devicePresent = 1;
   OSOCTET data[] = { 0x10 };
   connectionId.call.numocts = 1;
   connectionId.call.data = data;
   connectionId.device.t = T_ConnectionID_device_staticID;
   connectionId.device.u.staticID = &staticID;

   makeCallResult.t = T_MakeCallResult_initiatedCall;
   makeCallResult.u.initiatedCall = &connectionId;

   /* Encode */

   len = makeCallResultC.Encode();

   if (len < 0) {
      printf ("Encode of MakeCallResult failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

/* Encode ROSE header */

static int encodeROSEResponseHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen)
{
   ASN1T_CSTA_ROSE_PDU pdu;
   ASN1C_CSTA_ROSE_PDU pduC (encodeBuffer, pdu);
   ASN1T_ReturnResult returnResult;
   int len;

   /* Populate header structure */

   returnResult.m.resultPresent = 1;
   returnResult.invokeId.t = T_InvokeId_present;
   returnResult.invokeId.u.present = 1; /* arbitrary number: should be unique */
   returnResult.result.opcode.t = T_Code_local;
   returnResult.result.opcode.u.local = 10;   /* opeartion code for "makeCall" operation from Table 1 */

   /* This is where we get the previously encoded message component..   */
   returnResult.result.result.numocts = msglen;
   returnResult.result.result.data = (OSOCTET*) encodeBuffer.getMsgPtr();

   pdu.t = T_CSTA_ROSE_PDU_returnResult;
   pdu.u.returnResult = &returnResult;

   /* Encode */

   len = pduC.Encode();

   if (len < 0) {
      printf ("Encode ROSE PDU failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}
