#ifndef CLIENT_H
#define CLIENT_H

#include <stdio.h>
#include <stdlib.h>
#include "opcode.h"
#include "ACSE-1.h"
#include "CSTA-ROSE-PDU-types.h"
#include "CSTA-system-status.h"
#include "OSRTSocket.h"
#include "asn1berSocket.h"
#include "CSTA-ROSE-PDU-types.h"
#include "CSTA-alternate-call.h"
#include "CSTA-answer-call.h"
#include "CSTA-associate-data.h"
#include "CSTA-call-completion.h"
#include "CSTA-clear-call.h"
#include "CSTA-clear-connection.h"
#include "CSTA-conference-call.h"
#include "CSTA-consultation-call.h"
#include "CSTA-divert-call.h"
#include "CSTA-hold-call.h"
#include "CSTA-make-call.h"
#include "CSTA-make-predictive-call.h"
#include "CSTA-park-call.h"
#include "CSTA-query-device.h"
#include "CSTA-reconnect-call.h"
#include "CSTA-retrieve-call.h"
#include "CSTA-send-DTMF-tones.h"
#include "CSTA-set-feature.h"
#include "CSTA-single-step-conference.h"
#include "CSTA-single-step-transfer.h"
#include "CSTA-transfer-call.h"
#include "CSTA-event-report-definitions.h"
#include "CSTA-call-cleared-event.h"
#include "CSTA-conferenced-event.h"
#include "CSTA-connection-cleared-event.h"
#include "CSTA-delivered-event.h"
#include "CSTA-diverted-event.h"
#include "CSTA-established-event.h"
#include "CSTA-failed-event.h"
#include "CSTA-held-event.h"
#include "CSTA-network-reached-event.h"
#include "CSTA-originated-event.h"
#include "CSTA-queued-event.h"
#include "CSTA-retrieved-event.h"
#include "CSTA-service-initiated-event.h"
#include "CSTA-transferred-event.h"
#include "CSTA-auto-answer-event.h"
#include "CSTA-call-information-event.h"
#include "CSTA-do-not-disturb-event.h"
#include "CSTA-forwarding-event.h"
#include "CSTA-message-waiting-event.h"
#include "CSTA-microphone-mute-event.h"
#include "CSTA-speaker-mute-event.h"
#include "CSTA-speaker-volume-event.h"
#include "CSTA-agent-busy-event.h"
#include "CSTA-logged-on-event.h"
#include "CSTA-logged-off-event.h"
#include "CSTA-not-ready-event.h"
#include "CSTA-ready-event.h"
#include "CSTA-working-after-call-event.h"
#include "CSTA-back-in-service-event.h"
#include "CSTA-out-of-service-event.h"
#include "CSTA-private-event.h"
#include "CSTA-play-event.h"
#include "CSTA-record-event.h"
#include "CSTA-review-event.h"
#include "CSTA-stop-event.h"
#include "CSTA-suspend-play-event.h"
#include "CSTA-suspend-record-event.h"
#include "CSTA-voice-attributes-change-event.h"
#include "CSTA-route-request.h"
#include "CSTA-re-route-request.h"
#include "CSTA-Route-select-request.h"
#include "CSTA-route-used-request.h"
#include "CSTA-route-end-request.h"
#include "CSTA-escape-service.h"
#include "CSTA-system-status.h"
#include "CSTA-monitor-start.h"
#include "CSTA-change-monitor-filter.h"
#include "CSTA-monitor-stop.h"
#include "CSTA-snapshot-device.h"
#include "CSTA-snapshot-call.h"
#include "CSTA-start-data-path.h"
#include "CSTA-stop-data-path.h"
#include "CSTA-send-data.h"
#include "CSTA-send-multicast-data.h"
#include "CSTA-send-broadcast-data.h"
#include "CSTA-suspend-data-path.h"
#include "CSTA-data-path-suspended.h"
#include "CSTA-resume-data-path.h"
#include "CSTA-data-path-resumed.h"
#include "CSTA-fast-data.h"
#include "CSTA-concatenate-message.h"
#include "CSTA-delete-message.h"
#include "CSTA-play-message.h"
#include "CSTA-query-voice-attribute.h"
#include "CSTA-record-message.h"
#include "CSTA-reposition.h"
#include "CSTA-resume.h"
#include "CSTA-review.h"
#include "CSTA-set-voice-attribute.h"
#include "CSTA-stop.h"
#include "CSTA-suspend.h"
#include "CSTA-synthesize-message.h"
#include "CSTA-error-definition.h"
#include "CSTA-event-causes.h"
#include "CSTA-switching-function-objects.h"
#include "CSTA-device-identifiers.h"
#include "CSTA-call-connection-identifiers.h"
#include "CSTA-connection-states.h"
#include "CSTA-status-reporting.h"
#include "CSTA-device-feature-types.h"
#include "CSTA-security.h"
#include "CSTA-extension-types.h"
#include "CSTA-application-context-information.h"
#include "Remote-Operations-Generic-ROS-PDUs.h"
#include "Remote-Operations-Information-Objects.h"
#include "Remote-Operations-Useful-Definitions.h"

#define MAXMSGLEN 1024
#define MAX_NUM_SIZE	20 

class Client
{
public:
   OSBOOL trace;
   OSBOOL callInitiated;
   OSBOOL monitorInitiated;
   OSBOOL eventReceived;
   enum MessageType {messageonly, ietf, siemens_hipath_3000};
   MessageType mMessageType;
   ASN1T_ConnectionID mMostRecentCall;
   ASN1T_MonitorCrossRefID *pMostRecentMonitor;

   Client(OSBOOL _trace=TRUE):trace(_trace), mMessageType(messageonly), 
      callInitiated(FALSE), monitorInitiated(FALSE), eventReceived(FALSE) { }


   /* send & receive message via socket, also adding header bytes if necessary */
   int sendMessage (OSRTSocket& cstaSocket, 
      ASN1BEREncodeBuffer& encodeBuffer, size_t len);
   int receiveMessage (OSRTSocket& cstaSocket, 
      ASN1BERDecodeBuffer &decodeBuffer);

   /* stdin request functions */
   void getstring(char *prompt, char *buf, int size);
   int  getint(char *prompt);
   int  gethex(char *prompt);


   /* processing decoded CSTA message functions */
   int receiveCSTAMessage(OSRTSocket& cstaSocket);
   void processPDU(ASN1T_CSTA_ROSE_PDU& pdu, OSBOOL trace);
   void processInvoke(ASN1T_CSTA_ROSE_PDU& pdu, OSBOOL trace);
   void processReturnResult(ASN1T_CSTA_ROSE_PDU& pdu, OSBOOL trace);
   void processReturnError(ASN1T_CSTA_ROSE_PDU& pdu, OSBOOL trace);
   void processReject(ASN1T_CSTA_ROSE_PDU& pdu, OSBOOL trace);
   void processEvent(ASN1T_CSTAEventReportArgument& eventReportArg, OSBOOL trace);

   /* connection set up functions */
   int connect(OSRTSocket& cstaSocket);
   int release(OSRTSocket& cstaSocket);
   int receiveACSEMessage(OSRTSocket& cstaSocket);
   int receiveACSEConnectResponse(OSRTSocket& cstaSocket);
   int encodeACSEAbort (ASN1BEREncodeBuffer& encodeBuffer);
   int encodeACSEReleaseRequest (ASN1BEREncodeBuffer& encodeBuffer);
   int encodeACSEConnectionRequest (ASN1BEREncodeBuffer& encodeBuffer);

   /* ROSE header encode/decode functions */
   int encodeROSERequestHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                 int msglen, int opcode);
   int encodeROSEResponseHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                 int msglen, int opcode);

   /* CSTA II operation functions */

   /* makecall */
   int makeCall(OSRTSocket& cstaSocket);
   int encodeMakeCallRequest(ASN1BEREncodeBuffer& encodeBuffer);
   void processMakeCallResult(ASN1T_MakeCallResult& makeCallRes);

   /* transfercall */
   int transferCall (OSRTSocket& cstaSocket);
   int encodeTransferCallRequest (ASN1BEREncodeBuffer& encodeBuffer);
   void processTransferCallRes(ASN1T_TransferCallResult& transferCallRes);

   /* queryDevice */
   int queryDevice (OSRTSocket& cstaSocket);
   int encodeQueryDeviceRequest (ASN1BEREncodeBuffer& encodeBuffer);
   void processQueryDeviceRes(ASN1T_QueryDeviceResult& queryDeviceRes);

   /* monitorStop */
   int monitorStop (OSRTSocket& cstaSocket);
   int encodeMonitorStopRequest (ASN1BEREncodeBuffer& encodeBuffer);
   int encodeMonitorStopRequest (ASN1BEREncodeBuffer& encodeBuffer, 
      ASN1T_MonitorCrossRefID& crossRefID);
   void processMonitorStopRes(ASN1T_MonitorStopResult& monitorStopRes);

   /* monitorStart */
   int monitorStart (OSRTSocket& cstaSocket);
   int encodeMonitorStartRequest (ASN1BEREncodeBuffer& encodeBuffer);
   void processMonitorStartRes(ASN1T_MonitorStartResult& monitorStartRes);

   /* divertCall */
   int divertCall (OSRTSocket& cstaSocket);
   int encodeDivertCallRequest (ASN1BEREncodeBuffer& encodeBuffer);
   void processDivertCallRes(ASN1T_DivertCallResult& divertCallRes);

   /* answerCall */
   int answerCall (OSRTSocket& cstaSocket);
   int encodeAnswerCallRequest (ASN1BEREncodeBuffer& encodeBuffer);
   void processAnswerCallRes(ASN1T_AnswerCallResult& answerCallRes);

   /* systemStatus */
   int systemStatus (OSRTSocket& cstaSocket);
   int encodeCSTASystemStatusResponse (ASN1BEREncodeBuffer& encodeBuffer);
   void processSystemStatusReq( ASN1T_SystemStatusArgument& systemStatusArg);

};
#endif
