#include "client.h"


int Client::connect(OSRTSocket& cstaSocket)
{
   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int len;

   if (trace) {
      printf ("ACSE association \n" );
   }

   /* Initialize the encoding context */
   ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

   /* Encode operation argument */
   if ((len = encodeACSEConnectionRequest (encodeBuffer)) < 0) {
      return len;
   }

   msgptr = encodeBuffer.getMsgPtr();

   /* Write the encoded message out to the socket */
   sendMessage (cstaSocket, encodeBuffer, len);
   if (trace) {
      printf ("ACSE associate msg sent, len = %d \n", len);
   }

   int stat = receiveACSEConnectResponse (cstaSocket);	
   if (stat != 0) {
      printf ("recvMessage failed, %d \n", stat );
      return stat;
   }

   if(mMessageType == Client::siemens_hipath_3000 ) {
      systemStatus (cstaSocket);
   }

   return 0;
}

int Client::encodeACSEConnectionRequest (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_AARQ_apdu aarq_apdu;
   int len;
  
   if (trace) {
	   printf ("encode ACSE Connection Request\n" );
   }

   /*
   set CSTA 3 OID value, for CSTA 3 communication 
   { iso( 1) identified-organization( 3) icd-ecma( 12)
	standard( 0) csta2( 218) }
   */
   ASN1OBJID csta2oid = { 5, {1, 3, 12, 0, 218 } };
   aarq_apdu.aSO_context_name = csta2oid;

   /*
   For simplicity, following data is ignored

   It is necessary for the requesting and responding systems to specify
   the CSTA services that they support. As with the protocol version 
   information, 
   this is also achieved by carrying additional information in the 
   AARQ_apdu.user-information field of the request and response PDUs. The
   application association requestor shall:
   - list the services required from the serving application;
   - list the services it can supply.
   */

   /* All other optional fields are ignored for simplicity */

   /* Encode */
   ASN1T_ACSE_apdu acse_apdu;
   acse_apdu.t = T_ACSE_apdu_aarq;
   acse_apdu.u.aarq = &aarq_apdu;

   ASN1C_ACSE_apdu pdu(encodeBuffer, acse_apdu);

   len = pdu.Encode();

   if (len < 0) {
      printf ("Encode of ACSE pdu failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}


/* Cleanup Handler */
int Client::release(OSRTSocket& cstaSocket)
{
   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int len;

   if (trace) {
      printf ("ACSE release \n" );
   }

   /* Initialize the encoding context */
   ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

   /* Encode operation argument */
   if ((len = encodeACSEReleaseRequest (encodeBuffer)) < 0) {
      return len;
   }

   msgptr = encodeBuffer.getMsgPtr();

   /* Write the encoded message out to the socket */
   sendMessage (cstaSocket, encodeBuffer, len);
   if (trace) {
      printf ("ACSE release msg sent, len = %d \n", len);
   }

   int stat = receiveACSEMessage (cstaSocket);	
   if (stat != 0) {
      printf ("recvMessage failed, %d \n", stat );
      return stat;
   }
   return 0;
}

/* Encode ACSE connection Release Request 

The ACSE_apdu.rlrq(request) is transmitted and the CSTA Application 
waits for an ACSE_apdu.rlre(response). If a response is 
received then the connection is released for CSTA Applications.

*/
int Client::encodeACSEReleaseRequest (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_RLRQ_apdu rlrq_apdu;
   int len;

   if (trace) {
	   printf ("encode ACSE Release Request\n" );
   }

   rlrq_apdu.m.reasonPresent = 1;
   rlrq_apdu.reason = Release_request_reason::normal;

   /* All other optional fields are ignored for simplicity. */

   /* Encode */
   ASN1T_ACSE_apdu acse_apdu;
   acse_apdu.t = T_ACSE_apdu_rlrq;
   acse_apdu.u.rlrq = &rlrq_apdu;

   ASN1C_ACSE_apdu pdu(encodeBuffer, acse_apdu);

   len = pdu.Encode();

   if (len < 0) {
      printf ("Encode ACSE PDU failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

/* Encode ACSE connection abort, this is not a Request */

int Client::encodeACSEAbort (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_ABRT_apdu abrt_apdu;
   int len;

   if (trace) {
	   printf ("encode ACSE Abort\n" );
   }

   abrt_apdu.abort_source = ABRT_source::acse_service_user;

   /* All other optional fields are ignored for simplicity. */

   /* Encode */
   ASN1T_ACSE_apdu acse_apdu;
   acse_apdu.t = T_ACSE_apdu_abrt;
   acse_apdu.u.abrt = &abrt_apdu;

   ASN1C_ACSE_apdu pdu(encodeBuffer, acse_apdu);

   len = pdu.Encode();

   if (len < 0) {
      printf ("Encode ACSE PDU failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

int Client::receiveACSEMessage(OSRTSocket& cstaSocket)
{
   ASN1BERDecodeBuffer decodeBuffer;
   if(receiveMessage(cstaSocket, decodeBuffer) < 0) {
      printf("error: failed to receive message\n");
      return -1;
   }

   ASN1T_ACSE_apdu pdu;
   ASN1C_ACSE_apdu pduC (decodeBuffer, pdu);

   int stat = pduC.Decode ();

   if (stat == 0) {
      if (trace) {
         printf ("Decode of ACSE PDU was successful\n");
         pduC.Print ("pdu");
      }
   }
   else {
      printf ("Decode of ACSE PDU failed\n");
      decodeBuffer.printErrorInfo ();
      return -1;
   }

   /* Process the ACSE operation */
   //processACSEPDU (pdu, trace);
   printf ("***\n");

   return 0;
}
int Client::receiveACSEConnectResponse(OSRTSocket& cstaSocket)
{
   ASN1BERDecodeBuffer decodeBuffer;
   if(receiveMessage(cstaSocket, decodeBuffer) < 0) {
      printf("error: failed to receive message\n");
      return -1;
   }

   ASN1T_ACSE_apdu pdu;
   ASN1C_ACSE_apdu pduC (decodeBuffer, pdu);

   int stat = pduC.Decode ();

   if (stat == 0) {
      if (trace) {
         printf ("Decode of ACSE PDU was successful\n");
         pduC.Print ("pdu");
      }

      if (pdu.t == T_ACSE_apdu_aare) {
         switch(pdu.u.aare->result) {
            case Associate_result::accepted:
               printf ("ACSE connection established successfully\n");
               break;

            case Associate_result::rejected_permanent:
            case Associate_result::rejected_transient:
               printf ("error: ACSE connection rejected\n");
               printf ("       Please try again or check the login/passwd in ACSE request\n");
               break;

            default:
               break;
         }
      }
      else if (pdu.t == T_ACSE_apdu_abrt) {
         printf ("ACSE connection aborted by device.\n");
         asn1Print_ABRT_apdu ("ABRT_apdu", pdu.u.abrt);
      }
   }
   else {
      printf ("Decode of ACSE PDU failed\n");
      decodeBuffer.printErrorInfo ();
      return -1;
   }

   /* Process the ACSE operation */
   //processACSEPDU (pdu, trace);
   printf ("***\n");

   return 0;
}


