#include "client.h"

int Client::transferCall (OSRTSocket& cstaSocket)
{
   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int len;

   if (trace) {
      printf ("transfer Call \n" );
   }

   /* Initialize the encoding context */
   ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

   /* Encode operation argument */
   if ((len = encodeTransferCallRequest(encodeBuffer)) < 0) { return len; }

   /* Encode ROSE header on top of encoded argument */
   if ((len = encodeROSERequestHeader (encodeBuffer, len, transferCall_CODE)) < 0) { return len; }

   msgptr = encodeBuffer.getMsgPtr();


   /* Write the encoded message out to the socket */
   sendMessage (cstaSocket, encodeBuffer, len);
   if (trace) {
      printf ("transfer Call msg sent, len = %d \n", len);
   }

   int stat = receiveCSTAMessage (cstaSocket);	
   if (stat != 0) {
      printf ("recvMessage failed, %d \n", stat );
      return stat;
   }

   return 0;
}

int Client::encodeTransferCallRequest (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_TransferCallArgument transferCallArgument;
   ASN1C_TransferCallArgument transferCallArgumentC (encodeBuffer, transferCallArgument);
   int len;

   char heldDev[MAX_NUM_SIZE];
   char connDev[MAX_NUM_SIZE];

   getstring("Held device :", heldDev, sizeof(heldDev));
   getstring("Connected device :", connDev, sizeof(connDev));
   if (trace) {
	   printf ( "encode transfer Call Request, held %s, conn %s \n", heldDev, connDev );
   }

   /* To make it simple, we will omit all of the optional fields */

   /* load connection 1 for held device */
   ASN1T_DeviceID deviceID1;
   deviceID1.t = T_DeviceID_dialingNumber;
   deviceID1.u.dialingNumber = heldDev;

   ASN1T_ConnectionID connectionID1;
   connectionID1.m.callPresent = 0;
   connectionID1.m.devicePresent = 1;
   connectionID1.device.t = T_ConnectionID_device_staticID;
   connectionID1.device.u.staticID = &deviceID1;

   /* load connection 2 for connecting device */
   ASN1T_DeviceID deviceID2;
   deviceID2.t = T_DeviceID_dialingNumber;
   deviceID2.u.dialingNumber = connDev;

   ASN1T_ConnectionID connectionID2;
   connectionID2.m.callPresent = 0;
   connectionID2.m.devicePresent = 1;
   connectionID2.device.t = T_ConnectionID_device_staticID;
   connectionID2.device.u.staticID = &deviceID2;

   /* load both connections */
   ASN1T_ConnectionDetails_bothCalls connectionDetails_bothCalls;
   connectionDetails_bothCalls.heldCall = connectionID1;
   connectionDetails_bothCalls.activeCall = connectionID2;

   ASN1T_ConnectionDetails connectionDetails;
   connectionDetails.t = T_ConnectionDetails_bothCalls ;
   connectionDetails.u.bothCalls = &connectionDetails_bothCalls;

   transferCallArgument.t = T_TransferCallArgument_transferInfo;
   transferCallArgument.u.transferInfo = &connectionDetails;

   /* Encode */

   len = transferCallArgumentC.Encode();

   if (len < 0) {
      printf ("Encode of transferCallArgument failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

void Client::processTransferCallRes(ASN1T_TransferCallResult& transferCallRes)
{
   //TODO: user action for PBX response to transfer call
}
