/* Test driver to read and decode an encoded ASN.1 message */

#include <stdio.h>
#include <stdlib.h>
#include "ACSE-1.h"

#define MAXMSGLEN 1024
#define MAKE_CALL_OPCODE 10

int main (int argc, char** argv)
{
   OSOCTET	msgbuf[MAXMSGLEN];
   int		i, len, stat;
   FILE*        fp;
   const char*  filename = "message.dat";
   OSBOOL     trace = TRUE;
OSBOOL verbose = FALSE;

   /* Process command line arguments */

   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) verbose = TRUE;
         else if (!strcmp (argv[i], "-i")) filename = argv[++i];
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: writer [ -v ] [ -o <filename>\n");
            printf ("   -v  verbose mode: print trace info\n");
            printf ("   -i <filename>  read encoded msg from <filename>\n");
            printf ("   -notrace  do not display trace info\n");
            return 0;
         }
      }
   }

   /* Read input file into a memory buffer */

   if (fp = fopen (filename, "rb")) {
      len = fread (msgbuf, 1, sizeof(msgbuf), fp);
   }
   else {
      printf ("Error opening %s for read access\n", filename);
      return -1;
   }


      /* Init context structure */

      ASN1BERDecodeBuffer decodeBuffer (msgbuf, len);

      if (trace) decodeBuffer.binDump ();

      /* Decode ROSE header */

      ASN1T_ACSE_apdu pdu;
      ASN1C_ACSE_apdu pduC (decodeBuffer, pdu);

      stat = pduC.Decode ();

      if (stat == 0) {
         if (trace) {
            printf ("Decode of ACSE PDU was successful\n");
            pduC.Print ("pdu");
         }
      }
      else {
         printf ("Decode of ROSE PDU failed\n");
         decodeBuffer.printErrorInfo ();
         return -1;
      }

   return 0;
}
