#include "client.h"

int Client::answerCall (OSRTSocket& cstaSocket)
{
   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int len;

   if (trace) {
      printf ("answer Call \n" );
   }

   /* Initialize the encoding context */
   ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

   /* Encode operation argument */
   if ((len = encodeAnswerCallRequest (encodeBuffer)) < 0) {
      return len;
   }

   /* Encode ROSE header on top of encoded argument */
   if ((len = encodeROSERequestHeader (encodeBuffer, len, answerCall_CODE)) < 0) {
      return len;
   }

   msgptr = encodeBuffer.getMsgPtr();

   /* Write the encoded message out to the socket */

   sendMessage (cstaSocket, encodeBuffer, len);
   if (trace) {
      printf ("answer Call msg sent, len = %d \n", len);
   }

   int stat = receiveCSTAMessage (cstaSocket);	
   if (stat != 0) {
      printf ("recvMessage failed, %d \n", stat );
      return stat;
   }

   return 0;
}

int Client::encodeAnswerCallRequest (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_AnswerCallArgument answerCallArgument;
   ASN1C_AnswerCallArgument answerCallArgumentC (encodeBuffer, answerCallArgument);
   int len;

   char deviceNum[MAX_NUM_SIZE];
   getstring("Device to lift :", deviceNum, sizeof(deviceNum));
   if (trace) {
	   printf ( "encode Answer Call Request, num %s \n", deviceNum );
   }

   /* To make it simple, we will omit all of the optional fields */

   ASN1T_DeviceID deviceID;
   deviceID.t = T_DeviceID_dialingNumber;
   deviceID.u.dialingNumber = deviceNum;

   ASN1T_ConnectionID connectionID;
   connectionID.m.callPresent = 0;
   connectionID.m.devicePresent = 1;
   connectionID.device.t = T_ConnectionID_device_staticID;
   connectionID.device.u.staticID = &deviceID;
   
   answerCallArgument.t = T_AnswerCallArgument_callToBeAnswered;
   answerCallArgument.u.callToBeAnswered = &connectionID; 

   /* Encode */

   len = answerCallArgumentC.Encode();

   if (len < 0) {
      printf ("Encode of AnswerCallArgument failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

void Client::processAnswerCallRes(ASN1T_AnswerCallResult& answerCallRes)
{
   //TODO: user action for PBX response to answer call
}
