#include "client.h"

int Client::monitorStart(OSRTSocket& cstaSocket)
{
   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int len;

   if (trace) {
      printf ("Monitor Start \n" );
   }

   /* Initialize the encoding context */
   ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

   /* Encode operation argument */
   if ((len = encodeMonitorStartRequest (encodeBuffer)) < 0) 
      return len;

   /* Encode ROSE header on top of encoded argument */
   if ((len = encodeROSERequestHeader (encodeBuffer, len, monitorStart_CODE)) < 0) 
      return len;

   msgptr = encodeBuffer.getMsgPtr();

   /* Write the encoded message out to the socket */
   sendMessage (cstaSocket, encodeBuffer, len);
   if (trace) {
      printf ("monitor start message sent, len = %d \n", len);
   }

	int stat = receiveCSTAMessage (cstaSocket);
	if (stat != 0) {
		printf ("recvMessage failed, %d \n", stat );
		return stat;
	}
	return 0;
}

int Client::encodeMonitorStartRequest (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_MonitorStartArgument monStartArgument;
   ASN1C_MonitorStartArgument 
      monStartArgumentC (encodeBuffer, monStartArgument);
   int len;

   char deviceNum[MAX_NUM_SIZE];
   getstring("Device to monitor :", deviceNum, sizeof(deviceNum));
   ASN1T_DeviceID device;
   device.t = T_DeviceID_dialingNumber;
   device.u.dialingNumber = deviceNum;

   monStartArgument.monitorObject.t = T_CSTAObject_device;
   monStartArgument.monitorObject.u.device = &device;

   char mfpriv[10];
   getstring("Monitor Filter private(yes/no) :", mfpriv, sizeof(mfpriv));
   if(strcmp(mfpriv, "yes") == 0) {
      monStartArgument.m.monitorFilterPresent = 1;
      monStartArgument.monitorFilter.private_ = TRUE;
   }

   /* To make it simple, we will omit all of the optional fields */

   /* Encode */

   len = monStartArgumentC.Encode();

   if (len < 0) {
      printf ("Encode of MonitorStartArgument failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

void Client::processMonitorStartRes(ASN1T_MonitorStartResult& monitorStartRes)
{
   //TODO: user action for PBX response to MonitorStar
}
