#include "client.h"

int Client::queryDevice (OSRTSocket& cstaSocket)
{
   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int len;

   if (trace) {
      printf ("Query Device \n");
   }

   /* Initialize the encoding context */
   ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

   /* Encode operation argument */
   if ((len = encodeQueryDeviceRequest (encodeBuffer)) < 0) {
      return len;
   }

   /* Encode ROSE header on top of encoded argument */
   if ((len = encodeROSERequestHeader (encodeBuffer, len, queryDevice_CODE)) < 0) {
      return len;
   }

   msgptr = encodeBuffer.getMsgPtr();

   /* Write the encoded message out to the socket */
   sendMessage (cstaSocket, encodeBuffer, len);    
   if (trace) {
      printf ("query Device msg sent, len = %d \n", len);
   }

   int stat = receiveCSTAMessage (cstaSocket);	
   if (stat != 0) {
      printf ("recvMessage failed, %d \n", stat );
      return stat;
   }

   return 0;
}

int Client::encodeQueryDeviceRequest (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_QueryDeviceArgument queryDeviceArgument;
   ASN1C_QueryDeviceArgument queryDeviceArgumentC (encodeBuffer, queryDeviceArgument);
   int len;

   char deviceNum[MAX_NUM_SIZE];
   getstring("Device to query :", deviceNum, sizeof(deviceNum));
   if (trace) {
	   printf ( "encode Query Device Request, num %s \n", deviceNum );
   }

   /* To make it simple, we will omit all of the optional fields */

   ASN1T_DeviceID deviceId;
   deviceId.t = T_DeviceID_dialingNumber;
   deviceId.u.dialingNumber = deviceNum;

   queryDeviceArgument.device = deviceId; 
   queryDeviceArgument.feature = QueryDeviceFeature::deviceInfo;

   /* Encode */

   len = queryDeviceArgumentC.Encode();

   if (len < 0) {
      printf ("Encode of QueryDeviceArgument failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

void Client::processQueryDeviceRes(ASN1T_QueryDeviceResult& queryDeviceRes)
{
   //TODO: user action for PBX response to transfer call
}

