/* This test driver program encodes a data record and writes the        */
/* encoded result to an output file..                                   */

#include <stdio.h>
#include <stdlib.h>
#include "OSRTSocket.h"

#include "client.h"

int main (int argc, char** argv)
{
   int i;
   Client client;
   OSBOOL verbose = FALSE;

   /* Process command line arguments */

   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) verbose = TRUE;
         else if (!strcmp (argv[i], "-notrace")) client.trace = FALSE;
         else {
            printf ("usage: testClient [-notrace]\n");
            printf ("   -notrace    Disable trace information\n" );
            return 0;
         }
      }
   }

   /* get IP address & port number of PBX */
   char ipaddr[16];
   client.getstring("IP address of PBX/connecting device: ", ipaddr, 16);

   int port = client.getint("Port number of PBX/connecting device: ");
   printf ("\n");

   /* create socket connection */
   OSRTSocket cstaSocket;

   int socketReturn = cstaSocket.connect (ipaddr, port);
   if (socketReturn < 0) {
      printf ("connect to server socket failed, status = %i \n", socketReturn);
      return -2;
   }

   /* make ACSE connection with PBX */
   client.connect(cstaSocket);

   int test = 1;
   while (test) {
	
      printf("Enter test Action: \n");
      printf("------------------ \n");
      printf("\t1 - MakeCall \n");
      printf("\t2 - DivertCall \n");
      printf("\t3 - TranferCall \n");
      printf("\t4 - QueryDevice \n");
      printf("\t5 - AnswerCall \n");
      printf("\t6 - MonitorStart \n");
      printf("\t7 - MonitorStop \n");
      printf("\n");
      printf("\t0 - Quit \n");

      test = client.getint("Action : ");

      switch(test) {	
      case 1: /* MakeCall */ {
         client.makeCall(cstaSocket);
      }
         break;

      case 2: /* DivertCall */ {
         client.divertCall(cstaSocket);
      }
         break;

      case 3: /* TranferCall */ {
         client.transferCall(cstaSocket);
      }
         break;

      case 4: /* QueryDevice */ {
         client.queryDevice(cstaSocket);
      }
         break;

      case 5: /* AnswerCall */ {
         client.answerCall(cstaSocket);
      }
         break;
		
      case 6: /* MonitorStart */ {
         client.monitorStart(cstaSocket);
      }
         break;

      case 7: /* MonitorStop */ {
         client.monitorStop(cstaSocket);
      }
         break;

      case 0: { //end of calls
      }
         break;

      default: {
         printf("Bad action requested !\n");
      }
         break;
      } // switch
   }  //for

   client.release(cstaSocket);

   return 0;
}

/* input helper functions */

/* Get a string from command line */
void Client::getstring(char *prompt, char *buf, int size)
{
   printf("%s", prompt);
   fflush(stdout);

   fgets(buf, size, stdin);

   if (buf[strlen(buf) - 1] == '\n')
      buf[strlen(buf) - 1] = '\0';
}

/* Get an integer from command line */
int Client::getint(char *prompt)
{
   int val = 0;
   char buf[32];

   printf("%s", prompt);
   fflush(stdout);

   fgets(buf, sizeof(buf), stdin);
   sscanf(buf, "%d", &val);

   return(val);
}

/* Get an hexa number from command line */
int Client::gethex(char *prompt)
{
   int val = 0;
   char buf[32];

   printf("%s", prompt);
   fflush(stdout);

   fgets(buf, sizeof(buf), stdin);
   sscanf(buf, "%x", &val);

   return(val);
}

