/* This test driver program encodes a data record and writes the        */
/* encoded result to an output file..                                   */

#include <stdio.h>
#include <stdlib.h>
#include "CSTA-ROSE-PDU-types.h"
#include "CSTA-event-report-definitions.h"
#include "CSTA-network-reached-event.h"

#define MAXMSGLEN 1024

static int encodeNetworkReachedEvent (ASN1BEREncodeBuffer& encodeBuffer);

static int encodeROSEInvokeHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen);

int main (int argc, char** argv)
{
   /* Run-time support variables */

   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int		i, len;
   FILE*        fp;
   char*        filename = "message.dat";
   OSBOOL     trace = TRUE;
OSBOOL verbose = FALSE;

   /* Process command line arguments */

   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) verbose = TRUE;
         else if (!strcmp (argv[i], "-o")) filename = argv[++i];
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: writer [ -v ] [ -o <filename>\n");
            printf ("   -v  verbose mode: print trace info\n");
            printf ("   -o <filename>  write encoded msg to <filename>\n");
            printf ("   -notrace  do not display trace info\n");
            return 0;
         }
      }
   }


      /* Initialize the encoding context */

      ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

      /* Encode event info */

      if ((len = encodeNetworkReachedEvent (encodeBuffer)) < 0) return len;

      /* Encode ROSE header on top of encoded argument */

      if ((len = encodeROSEInvokeHeader (encodeBuffer, len)) < 0) return len;

      msgptr = encodeBuffer.getMsgPtr();

      if (trace) {
         encodeBuffer.binDump();
      }

      /* Write the encoded message out to the output file */

      if (fp = fopen (filename, "wb")) {
         fwrite (msgptr, 1, len, fp);
         fclose (fp);
      }
      else {
         printf ("Error opening %s for write access\n", filename);
         return -1;
      }

   return 0;

}

/* Encode "NetworkReached" event */

static int encodeNetworkReachedEvent (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_NetworkReachedEvent networkReached;

   /* To make it simple, we will omit all of the optional fields */

   /* NetworkReachedEventInfo.connection */
   ASN1T_DeviceID staticID;
   staticID.t = T_DeviceID_dialingNumber;
   staticID.u.dialingNumber = "023";

   networkReached.outboundConnection.m.callPresent = 1;
   networkReached.outboundConnection.m.devicePresent = 1;
   OSOCTET data[] = { 0x20 };
   networkReached.outboundConnection.call.numocts = 1;
   networkReached.outboundConnection.call.data = data;
   networkReached.outboundConnection.device.t = T_ConnectionID_device_staticID;
   networkReached.outboundConnection.device.u.staticID = &staticID;

   /* NetworkReachedEventInfo.trunkUsed */
   ASN1T_DeviceID deviceId2;
   deviceId2.t = T_DeviceID_dialingNumber;
   deviceId2.u.dialingNumber = "023";

   ASN1T_ExtendedDeviceID extdeviceId2;
   extdeviceId2.t = T_ExtendedDeviceID_deviceIdentifier;
   extdeviceId2.u.deviceIdentifier = &deviceId2;

   networkReached.trunkUsed.t = T_SubjectDeviceID_deviceIdentifier;
   networkReached.trunkUsed.u.deviceIdentifier = &extdeviceId2; 

   /* NetworkReachedEventInfo.calledDevice */
   ASN1T_DeviceID deviceId4;
   deviceId4.t = T_DeviceID_dialingNumber;
   deviceId4.u.dialingNumber = "18005551212";

   ASN1T_ExtendedDeviceID extdeviceId4;
   extdeviceId4.t = T_ExtendedDeviceID_deviceIdentifier;
   extdeviceId4.u.deviceIdentifier = &deviceId4;

   networkReached.calledDevice.t = T_CalledDeviceID_deviceIdentifier;
   networkReached.calledDevice.u.deviceIdentifier = &extdeviceId4; 

   networkReached.m.causePresent = 1;
   networkReached.cause = EventCause::maintenance;

   ASN1T_CallEvent callevent;
   callevent.t = T_CallEvent_networkReachedEvent;
   callevent.u.networkReachedEvent = &networkReached;

   ASN1T_CSTAEventReportArgument eventReportArg;
   ASN1C_CSTAEventReportArgument eventReportArgC(encodeBuffer, eventReportArg);
   int len;

   /* CSTAEventReportArgument */
   OSOCTET data2[] = { 0x99 };
   eventReportArg.crossRefIdentifier.numocts = 1;
   eventReportArg.crossRefIdentifier.data = data2;
   eventReportArg.eventSpecificInfo.t = T_EventSpecificInfo_callEvent;
   eventReportArg.eventSpecificInfo.u.callEvent = &callevent;

   /* Encode */

   len = eventReportArgC.Encode();

   if (len < 0) {
      printf ("Encode of CSTAEventReportArgument failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

/* Encode ROSE header */

static int encodeROSEInvokeHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen)
{
   ASN1T_CSTA_ROSE_PDU pdu;
   ASN1C_CSTA_ROSE_PDU pduC (encodeBuffer, pdu);
   ASN1T_CSTA_ROSE_PDU_invoke invoke;
   int len;

   /* Populate header structure */

   invoke.m.argumentPresent = 1;
   invoke.invokeId.t = T_InvokeId_present;
   invoke.invokeId.u.present = 1; /* arbitrary number: should be unique */
   invoke.opcode.t = T_Code_local;
   invoke.opcode.u.local = 21;   /* opeartion code for "cSTAEventReport" operation from Table 1 */

   /* This is where we get the previously encoded message component..   */
   invoke.argument.numocts = msglen;
   invoke.argument.data = (OSOCTET*) encodeBuffer.getMsgPtr();

   pdu.t = T_CSTA_ROSE_PDU_invoke;
   pdu.u.invoke = &invoke;

   /* Encode */

   len = pduC.Encode();

   if (len < 0) {
      printf ("Encode ROSE PDU failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}
