/* This test driver program encodes a data record and writes the        */
/* encoded result to an output file..                                   */

#include <stdio.h>
#include <stdlib.h>
#include "CSTA-call-connection-identifiers.h"

#define MAXMSGLEN 1024

static void setConnectionIds (ASN1BEREncodeBuffer& encodeBuffer);

int main (int argc, char** argv)
{
   ASN1BEREncodeBuffer encodeBuffer;
   setConnectionIds (encodeBuffer);

   return 0;

}

/* sample function to set different values for ConnectionId */

static void setConnectionIds (ASN1BEREncodeBuffer& encodeBuffer)
{
   /*
    <connectionID>
      <callID>1</callID> 
      <deviceID>22222</deviceID> 
    </connectionID>
   
   { both { callID '1'H , deviceId { staticID:dialingNumber: "22222" } } }
   */
   ASN1T_DeviceID staticID1;
   staticID1.t = T_DeviceID_dialingNumber;
   staticID1.u.dialingNumber = "22343";

   ASN1T_ConnectionID connectionID1;
   connectionID1.m.callPresent = 1;
   connectionID1.m.devicePresent = 1;
   OSOCTET data1[] = { 0x10 };
   connectionID1.call.numocts = 1;
   connectionID1.call.data = data1;
   connectionID1.device.t = T_ConnectionID_device_staticID;
   connectionID1.device.u.staticID = &staticID1;


   /*
    <connectionID>
      <callID>1</callID> 
    </connectionID>

   { callID  '1'H }
   */

   ASN1T_ConnectionID connectionID2;
   connectionID2.m.callPresent = 1;
   connectionID2.m.devicePresent = 0;
   OSOCTET data2[] = { 0x10 };
   connectionID2.call.numocts = 1;
   connectionID2.call.data = data2;

   /*
    <connectionID>
      <deviceID>22222</deviceID> 
    </connectionID>

   { deviceID { staticID:dialingNumber: "22222" } } 
   */

   ASN1T_DeviceID staticID3;
   staticID3.t = T_DeviceID_dialingNumber;
   staticID3.u.dialingNumber = "22343";

   ASN1T_ConnectionID connectionID3;
   connectionID3.m.callPresent = 0;
   connectionID3.m.devicePresent = 1;
   connectionID3.device.t = T_ConnectionID_device_staticID;
   connectionID3.device.u.staticID = &staticID3;

}

