/* This test driver program encodes a data record and writes the        */
/* encoded result to an output file..                                   */

#include <stdio.h>
#include <stdlib.h>
#include "CSTA-ROSE-PDU-types.h"
#include "CSTA-monitor-start.h"

#define MAXMSGLEN 1024

static int encodeMonitorStartArgument (ASN1BEREncodeBuffer& encodeBuffer);

static int encodeROSEInvokeHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen);

int main (int argc, char** argv)
{
   /* Run-time support variables */

   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int		i, len;
   FILE*        fp;
   char*        filename = "message.dat";
   OSBOOL     trace = TRUE;
   OSBOOL verbose = FALSE;

   /* Process command line arguments */

   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) verbose = TRUE;
         else if (!strcmp (argv[i], "-o")) filename = argv[++i];
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: writer [ -v ] [ -o <filename>\n");
            printf ("   -v  verbose mode: print trace info\n");
            printf ("   -o <filename>  write encoded msg to <filename>\n");
            printf ("   -notrace  do not display trace info\n");
            return 0;
         }
      }
   }


   /* Initialize the encoding context */

   ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

   /* Encode operation argument */

   if ((len = encodeMonitorStartArgument (encodeBuffer)) < 0) return len;

   /* Encode ROSE header on top of encoded argument */

   if ((len = encodeROSEInvokeHeader (encodeBuffer, len)) < 0) return len;

   msgptr = encodeBuffer.getMsgPtr();

   if (trace) {
      encodeBuffer.binDump();
   }

   /* Write the encoded message out to the output file */

   if (fp = fopen (filename, "wb")) {
      fwrite (msgptr, 1, len, fp);
      fclose (fp);
   }
   else {
      printf ("Error opening %s for write access\n", filename);
      return -1;
   }

   return 0;

}

/* Encode operation argument */

static int encodeMonitorStartArgument (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_MonitorStartArgument MonitorStartArgument;
   ASN1C_MonitorStartArgument monStartArg (encodeBuffer, MonitorStartArgument);
   
   //Device to monitor
   ASN1T_DeviceID deviceToMonitor;
   deviceToMonitor.t = T_DeviceID_dialingNumber;
   deviceToMonitor.u.dialingNumber = "100";

   //Monitor Device, t=2
   MonitorStartArgument.monitorObject.t = T_CSTAObject_device;
   MonitorStartArgument.monitorObject.u.device = &deviceToMonitor;

   //Object identifier
   ASN1OBJID ThisID = { 6, { 0, 1, 1, 2, 4, 5} };

   MonitorStartArgument.m.extensionsPresent = 1;

   //PRIVATEDATAPRESENT set to 1;
   MonitorStartArgument.extensions.m.privateDataPresent = 1;

   //MonitorStartArgument.extensions.privateData.m.manufacturerPresent = 1;
   //MonitorStartArgument.extensions.privateData.m.newwayPresent = 0;
   //MonitorStartArgument.extensions.privateData.m.rolmPrivateDataPresent = 0;
   //MonitorStartArgument.extensions.privateData.manufacturer = ThisID;

   ASN1T_CSTA_extension_types_CSTAPrivateData privateData;
   OSOCTET private_octs[] = 
      { 4, 5, 1, 2, 3, 4, 5 }; // octet string (tag - 4), length - 5 
   privateData.numocts = sizeof (private_octs) / sizeof (private_octs[0]);
   privateData.data = private_octs;
   
   rtxDListAppend (encodeBuffer.getCtxtPtr(), 
                   &MonitorStartArgument.extensions.privateData,
                   &privateData);

   /* Encode */

   int len = monStartArg.Encode();

   if (len < 0) {
      printf ("Encode of MonitorStartArgument failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

/* Encode ROSE header */

static int encodeROSEInvokeHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen)
{
   ASN1T_CSTA_ROSE_PDU pdu;
   ASN1C_CSTA_ROSE_PDU pduC (encodeBuffer, pdu);
   ASN1T_CSTA_ROSE_PDU_invoke invoke;
   int len;

   /* Populate header structure */

   invoke.m.argumentPresent = 1;
   invoke.invokeId.t = T_InvokeId_present;
   invoke.invokeId.u.present = 1; /* arbitrary number: should be unique */
   invoke.opcode.t = T_Code_local;
   invoke.opcode.u.local = 10; 

   /* This is where we get the previously encoded message component..   */
   invoke.argument.numocts = msglen;
   invoke.argument.data = (OSOCTET*) encodeBuffer.getMsgPtr();

   pdu.t = T_CSTA_ROSE_PDU_invoke;
   pdu.u.invoke = &invoke;

   /* Encode */

   len = pduC.Encode();

   if (len < 0) {
      printf ("Encode ROSE PDU failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}
