.SUFFIXES : .c .cc .cpp .obj

.cpp.obj:
	$(CCC) $(CCFLAGS) -c $(IPATHS) $<

.c.obj:
	$(CC) $(CFLAGS) -c $(IPATHS) $<

.cc.obj:
	$(CC) $(CFLAGS) -c $(IPATHS) $<

# The following symbols should be valid on all Windows systems
CC	  = cl
CCC	  = cl
CSC   = csc
CFLAGS_	  = -nologo -EHsc -W3 -Zm200
CCFLAGS_  = $(CFLAGS_)
CVARS0_	  = -DASN1RT -DWIN32 -D_WIN32 -D_BIND_TO_CURRENT_VCLIBS_VERSION -GF
CVARSDLL_ = $(CVARSRTDLL_) -DASN1DLL
COPTIMIZE0_ = -Ob2 -Gy -Ox 
CDEBUG0_  = -Zi -D_DEBUG
FS	  = ;
LIBCMD	  = lib /NOLOGO /OUT:$@
LIBADD	  = lib /NOLOGO /OUT:$@ $@
LINK	  = cl
LINKDLL	  = cl
LINKDLLOPTD = /LDd /Fe$@ /link $(LINKDBG_)
LINKDLLOPTR = /LD /Fe$@ /link
LINKOPT0  = /nologo /link /OUT:$@
LINKDBG_  = /MAP /DEBUG
LINKDBGRLM_ = /MAP /DEBUG /NODEFAULTLIB:LIBCMT.lib
LINKOPTM_ = /OPT:REF  
OBJOUT	  = -Fo$@
OUTFILE   = -Fo
PLATFORM  = WIN32
PS	  = \#
PURECVAR  = -TC

CVARSR_	  = $(CVARS0_) -D_MT -MT
CVARSMTR_  = $(CVARS0_) -D_MT -MT
CVARSMDR_  = $(CVARS0_) -D_MT -D_DLL -MD

CVARSCRTDLLR_ = $(CVARS0_) -D_MT -D_DLL -MD
CVARSRTDLLR_ = $(CVARS0_) -D_MT -D_DLL -MD $(USEDLL)
LINKOPTR_  = $(LINKOPT0) /OPT:REF  
LINKOPTRLMR_ = $(LINKOPT0) /OPT:REF  
LINKOPT2R  = /nologo /link /OUT:$@ /OPT:REF

CVARSD_	   = $(CVARS0_) -MTd
CVARSMTD_  = $(CVARS0_) -D_MT -MTd
CVARSMDD_  = $(CVARS0_) -D_MT -D_DLL -MDd

CVARSCRTDLLD_ = $(CVARS0_) -D_MT -D_DLL -MDd
CVARSRTDLLD_ = $(CVARS0_) -D_MT -D_DLL -MDd $(USEDLL)
LINKOPTD_  = $(LINKOPT0) $(LINKDBG_)
LINKOPTRLMD_ = $(LINKOPT0) $(LINKDBGRLM_)
LINKOPT2D  = /nologo /link /OUT:$@ $(LINKDBG_)
COPTIMIZE_ = $(COPTIMIZE0_) -D_OPTIMIZED
CSPACEOPT_ = /O1
CTIMEOPT_  = /O2

JSOURCE = -source 1.6
JTARGET = -target 1.6

# START RELEASE
#BLDSUBDIR = release
#CDEV_     = -D_TRACE -Od
#CDEBUG_   = $(CDEV_) $(CDEBUG0_)
#CBLDTYPE_ = $(COPTIMIZE_)
#CVARS_    = $(CVARSR_)
#CVARSMT_  = $(CVARSMTR_)
#CVARSMD_  = $(CVARSMDR_)
#CVARSCRTDLL_ = $(CVARSCRTDLLR_)
#CVARSRTDLL_ = $(CVARSRTDLLR_)
#LINKOPT_  = $(LINKOPTR_)
#LINKOPTRLM_ = $(LINKOPTRLMR_)
#LINKOPT2  = $(LINKOPT2R)
#RLMLIBNAME = rlmclient_md.lib
#RTLIBDIRSFX = _opt
# END RELEASE

# START DEBUG
BLDSUBDIR = debug
CDEV_     = -D_TRACE -Od $(CDEBUG0_)
CDEBUG_	  = $(CDEV_)
CBLDTYPE_ = $(CDEBUG_)
CVARS_    = $(CVARSD_)
CVARSMT_  = $(CVARSMTD_)
CVARSMD_  = $(CVARSMDD_)
CVARSCRTDLL_ = $(CVARSCRTDLLD_)
CVARSRTDLL_ = $(CVARSRTDLLD_)
LINKOPT_  = $(LINKOPTD_)
LINKOPTRLM_ = $(LINKOPTRLMD_)
LINKOPT2  = $(LINKOPT2D)
RLMLIBNAME = rlmclient_mdd.lib
RTLIBDIRSFX =
# END DEBUG

LINKOPTDYN_ = $(LINKOPT_)

# File extensions
EXE	= .exe
OBJ	= .obj

# Run-time library
LIBPFX	=
LIBEXT	= lib
LPPFX	= -LIBPATH:
LLPFX   =
LLEXT   = .lib
LLAEXT  = _a.$(LIBEXT)
A       = _a.$(LIBEXT)
D       = d
MTA     = $(A)
MDA     = md_a.$(LIBEXT)
IMP     = .$(LIBEXT)
IMPEXT  = $(IMP)
IMPLINK = $(IMPEXT)
DLL     = .dll
RTDIRSFX =

# O/S commands
COPY	 = -copy
MOVE	 = -move
MV	 = $(MOVE)
RM	 = -del
STRIP	 = strip -g -S
MAKE     = nmake
RMDIR = -rmdir /S /Q
MKDIR = -mkdir

RM_MSVC_FILES = $(RM) *.pdb *.map *.ilk

LLSYS = user32.lib ws2_32.lib advapi32.lib gdi32.lib shell32.lib winhttp.lib ole32.lib Iphlpapi.lib

# LIBXML2 defs
LIBXML2ROOT = $(OSROOTDIR)/libxml2src
LIBXML2INC  = $(LIBXML2ROOT)/include
LIBXML2NAME = libxml2_a.lib
LIBXML2LINK = libxml2_a.lib
LIBXML2MDNAME = libxml2md_a.lib
LIBXML2MDLINK = libxml2md_a.lib


# RLM defs
RLMLIBDIR = $(OSROOTDIR)/licmgr/RLM/x86_w<x>
LLRLM = $(RLMLIBNAME) wbemuuid.lib

# Directories
CDIR    = c
CPPDIR  = cpp

# START ASN1C
COMPACT	  = -D_COMPACT
NOLIC_	  = -D_NO_LICENSE_CHECK
# Link libraries
# The template is: LLxxxSSS, where:
#    xxx - BER. PER, XER or RT;
#    SSS - suffix (Windows only):
#       MT  - multi-threaded
#       MD  - DLL-ready
#       IMP - import library of DLL
LLBER	= asn1ber$(A)
LLBERMT	= asn1ber$(MTA)
LLBERMD	= asn1ber$(MDA)
LLBERIMP = asn1ber$(IMP)
LLBERIMPD = asn1berd$(IMP)
LLCBOR	= osrtcbor$(A)
LLCBORMD = osrtcbor$(MDA)
LLCBORIMP= osrtcbor$(IMP)
LLCBORIMPD = asn1cbord$(IMP)
LLJSON	= asn1json$(A)
LLJSONMT = asn1json$(MTA)
LLJSONMD = asn1json$(MDA)
LLJSONIMP= asn1json$(IMP)
LLJSONIMPD = asn1jsond$(IMP)
LLMDER	= asn1mder$(A)
LLMDERMT = asn1mder$(MTA)
LLMDERMD = asn1mder$(MDA)
LLMDERIMP= asn1mder$(IMP)
LLMDERIMPD = asn1mderd$(IMP)
LLOER = asn1oer$(A)
LLOERMT	= asn1oer$(MTA)
LLOERMD	= asn1oer$(MDA)
LLOERIMP= asn1oer$(IMP)
LLOERIMPD = asn1oerd$(IMP)
LLPER	= asn1per$(A)
LLPERMT	= asn1per$(MTA)
LLPERMD	= asn1per$(MDA)
LLPERIMP = asn1per$(IMP)
LLPERIMPD = asn1perd$(IMP)
LLXER	= asn1xer$(A)
LLXERMT	= asn1xer$(MTA)
LLXERMD	= asn1xer$(MDA)
LLXERIMP= asn1xer$(IMP)
LLXERIMPD = asn1xerd$(IMP)
LLXML	= asn1xml$(A)
LLXMLMT	= asn1xml$(MTA)
LLXMLMD	= asn1xml$(MDA)
LLXMLIMP= asn1xml$(IMP)
LLXMLIMPD = asn1xmld$(IMP)
LLRT	= asn1rt$(A)
LLRTMT	= asn1rt$(MTA)
LLRTMD	= asn1rt$(MDA)
LLRTIMP = asn1rt$(IMP)
LLRTIMPD = asn1rtd$(IMP)
LLLIC	= license.lib
LLASN1C = asn1c.lib
LLOSCOM = $(OSLIBNAME)
LLX2A   = $(X2ALIBNAME)
LLX2AAC = $(X2AACLIBNAME)
LLASN1RT3GPP = asn1rt3gpp$(A)
LLASN1UTIL = asn1util$(A)
USEDLL  = -DUSERTDLL -DUSERTXDLL -DUSEASN1RTDLL -DUSEASN1BERDLL -DUSEASN1PERDLL -DUSEASN1XERDLL -DUSEXMLDLL

# Library names
# The template is: xxxLLLsssNAME, where:
#    xxx - BER. PER, XER or RT;
#    LLL - LIB or DLL:
#    sss - suffix (Windows only):
#       MT  - multi-threaded
#       MD  - DLL-ready
#       IMP - import library of DLL
A3GPPLIBNAME = asn1rt3gpp$(A)
AUTILLIBNAME = asn1util$(A)
BERLIBNAME   = asn1ber$(A)
BERLIBMTNAME = asn1ber$(MTA)
BERLIBMDNAME = asn1ber$(MDA)
BERLIBIMPNAME= asn1ber$(IMP)
BERLIBIMPNAMED = asn1berd$(IMP)
BERDLLNAME   = asn1ber$(DLL)
BERDLLNAMED  = asn1berd$(DLL)
CBORLIBNAME   = osrtcbor$(A)
CBORLIBMDNAME = osrtcbor$(MDA)
CBORLIBIMPNAME= osrtcbor$(IMP)
CBORLIBIMPNAMED = osrtcbord$(IMP)
CBORDLLNAME   = osrtcbor$(DLL)
CBORDLLNAMED  = osrtcbord$(DLL)
JSONLIBNAME   = asn1json$(A)
JSONLIBMTNAME = asn1json$(MTA)
JSONLIBMDNAME = asn1json$(MDA)
JSONLIBIMPNAME= asn1json$(IMP)
JSONLIBIMPNAMED = asn1jsond$(IMP)
JSONDLLNAME   = asn1json$(DLL)
JSONDLLNAMED  = asn1jsond$(DLL)
PERLIBNAME   = asn1per$(A)
PERLIBMTNAME = asn1per$(MTA)
PERLIBMDNAME = asn1per$(MDA)
PERLIBIMPNAME= asn1per$(IMP)
PERLIBIMPNAMED = asn1perd$(IMP)
PERDLLNAME   = asn1per$(DLL)
PERDLLNAMED  = asn1perd$(DLL)
LICLIBNAME   = license.lib
OSLIBNAME    = oscom_a.lib
RTLIBNAME    = asn1rt$(A)  
RTLIBMTNAME  = asn1rt$(MTA)
RTLIBMDNAME  = asn1rt$(MDA)
RTLIBIMPNAME = asn1rt$(IMP)
RTLIBIMPNAMED = asn1rtd$(IMP)
RTDLLNAME    = asn1rt$(DLL)  
RTDLLNAMED   = asn1rtd$(DLL)
XERLIBNAME   = asn1xer$(A)
XERLIBMTNAME = asn1xer$(MTA)
XERLIBMDNAME = asn1xer$(MDA)
XERLIBIMPNAME= asn1xer$(IMP)
XERLIBIMPNAMED = asn1xerd$(IMP)
XERDLLNAME   = asn1xer$(DLL)
XERDLLNAMED  = asn1xerd$(DLL)
XMLLIBNAME   = asn1xml$(A)
XMLLIBMTNAME = asn1xml$(MTA)
XMLLIBMDNAME = asn1xml$(MDA)
XMLLIBIMPNAME= asn1xml$(IMP)
XMLLIBIMPNAMED = asn1xmld$(IMP)
XMLDLLNAME   = asn1xml$(DLL)
XMLDLLNAMED  = asn1xmld$(DLL)
X2ALIBNAME   = xsd2asn1_a.lib
X2AACLIBNAME = xsd2asn1ac_a.lib

# Run-time library set used in ASN1C link
LLACXRT = $(LLXMLMD) $(LLRTMD) $(LIBXML2MDLINK)
LLACLRT = $(LLBERMD) $(LLACXRT)
LLX2ART = $(LLPERMD) $(LLACLRT)

# END ASN1C

# Added because of -TP mismatch
# commented out because is causing problems in the C++ run-time build (ED)
# MCOMFLAGS    = -TP
