#include "ACSE-1.h"
#include "CSTA-ROSE-PDU-types.h"
#include "CSTA-system-status.h"
#include "OSRTSocket.h"
#include "CSTA-application-context-information-csta3.h"

class SiemensClient {

 private:
   OSBOOL mTrace;

 public:
   SiemensClient(): mTrace(FALSE) { }
   ~SiemensClient() { }
   
   /* Set up connection functions */
   int setup (OSRTSocket& cstaSocket);
   int encodeACSEConnectionRequest (ASN1BEREncodeBuffer& encodeBuffer);
   int encodeCSTASystemStatusRes (ASN1BEREncodeBuffer& encodeBuffer);
   int encodeROSEResponseHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                 int msglen, int opcode);
   int sendACSEConnectionRequest (OSRTSocket& cstaSocket);
   int sendCSTASystemStatusRes (OSRTSocket& cstaSocket);
   int recvCSTASystemStatusRes (OSRTSocket& cstaSocket);
   
   /* Release connection functions */
   int release (OSRTSocket& cstaSocket);
   int encodeACSEReleaseRequest (ASN1BEREncodeBuffer& encodeBuffer);


   /* other functions */
   void setTrace(OSBOOL value) { mTrace = value; }
   int sendMessage (OSRTSocket& cstaSocket, 
                    ASN1BEREncodeBuffer& encodeBuffer, size_t len);
   int recvMessage (OSRTSocket& cstaSocket,  
                    OSOCTET* msgbuf, int msgbufsize);
   int recvACSEMessage (OSRTSocket& cstaSocket);
   int recvCSTAMessage (OSRTSocket& cstaSocket);

};
