/* This test driver program encodes a data record and writes the        */
/* encoded result to an output file..                                   */

#include <stdio.h>
#include <stdlib.h>
#include "CSTA-ROSE-PDU-types.h"
#include "CSTA-event-report-definitions.h"

#define MAXMSGLEN 1024

static int encodeEventReportRequest (ASN1BEREncodeBuffer& encodeBuffer);

static int encodeROSEInvokeHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen);

int main (int argc, char** argv)
{
   /* Run-time support variables */

   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int		i, len;
   FILE*        fp;
   const char*        filename = "message.dat";
   OSBOOL     trace = TRUE;

   /* Process command line arguments */

   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) trace = TRUE;
         else if (!strcmp (argv[i], "-o")) filename = argv[++i];
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: writer [ -v ] [ -o <filename>\n");
            printf ("   -v  verbose mode: print trace info\n");
            printf ("   -o <filename>  write encoded msg to <filename>\n");
            printf ("   -notrace  do not display trace info\n");
            return 0;
         }
      }
   }


      /* Initialize the encoding context */

      ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

      /* Encode operation argument */

      if ((len = encodeEventReportRequest (encodeBuffer)) < 0) return len;

      /* Encode ROSE header on top of encoded argument */

      if ((len = encodeROSEInvokeHeader (encodeBuffer, len)) < 0) return len;

      msgptr = encodeBuffer.getMsgPtr();

      if (trace) {
         encodeBuffer.binDump();
      }

      /* Write the encoded message out to the output file */

      /* Note that g++ on Linux suggests the inner parentheses around the
         "assignment used as truth value".  I disagree, but here they are to
         eliminate the warning message.  */
      if ((fp = fopen (filename, "wb"))) {
         fwrite (msgptr, 1, len, fp);
         fclose (fp);
      }
      else {
         printf ("Error opening %s for write access\n", filename);
         return -1;
      }

   return 0;

}

/* Encode "Conferenced" event for "cSTAEventReport" operation */

static int encodeEventReportRequest (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_cerd_CSTAEventReportArgument eventReportArg;
   ASN1C_cerd_CSTAEventReportArgument eventReportArgC(encodeBuffer, eventReportArg);
   int len;

   /* To make it simple, we will omit all of the optional fields */
   ASN1T_ConferencedEvent conferenced;

   /* ConferencedEvent.primaryOldCall */
   ASN1T_ConnectionID_both both;
   both.callID.numocts = 1;
   OSOCTET data1 = 0x10;
   both.callID.data = &data1;
   ASN1T_DeviceID staticID;
   staticID.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   staticID.deviceIdentifier.u.dialingNumber = "22343";
   both.deviceID.t = T_LocalDeviceID_staticID;
   both.deviceID.u.staticID = &staticID;
   conferenced.primaryOldCall.t = T_ConnectionID_both;
   conferenced.primaryOldCall.u.both = &both;

   /* ConferencedEvent.conferencingDevice */
   ASN1T_DeviceID deviceIdentifier1;
   deviceIdentifier1.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   deviceIdentifier1.deviceIdentifier.u.dialingNumber = "22343";
   conferenced.conferencingDevice.t = T_SubjectDeviceID_deviceIdentifier;
   conferenced.conferencingDevice.u.deviceIdentifier = &deviceIdentifier1; 

   /* ConferencedEvent.addedParty */
   ASN1T_DeviceID deviceIdentifier2;
   deviceIdentifier2.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   deviceIdentifier2.deviceIdentifier.u.dialingNumber = "55555";
   conferenced.addedParty.t = T_SubjectDeviceID_deviceIdentifier;
   conferenced.addedParty.u.deviceIdentifier = &deviceIdentifier2; 

   /* ConferencedEvent.ConnectionList element 1 */
   ASN1T_ConnectionList_element elem1;
    
   ASN1T_DeviceID elem1_staticID;
   elem1_staticID.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   elem1_staticID.deviceIdentifier.u.dialingNumber = "22343";
   ASN1T_ConnectionID_both elem1_both;
   elem1_both.callID.numocts = 1;
   OSOCTET data2 = 0x10;
   elem1_both.callID.data = &data2;
   elem1_both.deviceID.t = T_LocalDeviceID_staticID;
   elem1_both.deviceID.u.staticID = &elem1_staticID;
   elem1.m.newConnectionPresent = 1;
   elem1.newConnection.t = T_ConnectionID_both;
   elem1.newConnection.u.both = &elem1_both;

   ASN1T_DeviceID elem1_staticID2;
   elem1_staticID2.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   elem1_staticID2.deviceIdentifier.u.dialingNumber = "22343";
   ASN1T_ConnectionID_both elem1_both2;
   elem1_both2.callID.numocts = 1;
   OSOCTET data3 = 0x10;
   elem1_both2.callID.data = &data3;
   elem1_both2.deviceID.t = T_LocalDeviceID_staticID;
   elem1_both2.deviceID.u.staticID = &elem1_staticID2;
   elem1.m.oldConnectionPresent = 1;
   elem1.oldConnection.t = T_ConnectionID_both;
   elem1.oldConnection.u.both = &elem1_both2;

   ASN1T_DeviceID elem1_deviceID3;
   elem1_deviceID3.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   elem1_deviceID3.deviceIdentifier.u.dialingNumber = "22343";
   elem1.m.endpointPresent = 1;
   elem1.endpoint.t = T_ConnectionList_element_endpoint_deviceID;
   elem1.endpoint.u.deviceID = &elem1_deviceID3;

   rtxDListAppend(encodeBuffer.getCtxtPtr(), 
      &conferenced.conferenceConnections, &elem1);

   /* ConferencedEvent.ConnectionList element 2 */
   ASN1T_ConnectionList_element elem2;
    
   ASN1T_DeviceID elem2_staticID;
   elem2_staticID.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   elem2_staticID.deviceIdentifier.u.dialingNumber = "33333";
   ASN1T_ConnectionID_both elem2_both;
   elem2_both.callID.numocts = 1;
   OSOCTET data4 = 0x10;
   elem2_both.callID.data = &data4;
   elem2_both.deviceID.t = T_LocalDeviceID_staticID;
   elem2_both.deviceID.u.staticID = &elem2_staticID;
   elem2.m.newConnectionPresent = 1;
   elem2.newConnection.t = T_ConnectionID_both;
   elem2.newConnection.u.both = &elem2_both;

   ASN1T_DeviceID elem2_staticID2;
   elem2_staticID2.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   elem2_staticID2.deviceIdentifier.u.dialingNumber = "33333";
   ASN1T_ConnectionID_both elem2_both2;
   elem2_both2.callID.numocts = 1;
   OSOCTET data5 = 0x10;
   elem2_both2.callID.data = &data5;
   elem2_both2.deviceID.t = T_LocalDeviceID_staticID;
   elem2_both2.deviceID.u.staticID = &elem2_staticID2;
   elem2.m.oldConnectionPresent = 1;
   elem2.oldConnection.t = T_ConnectionID_both;
   elem2.oldConnection.u.both = &elem2_both2;

   ASN1T_DeviceID elem2_deviceID3;
   elem2_deviceID3.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   elem2_deviceID3.deviceIdentifier.u.dialingNumber = "33333";
   elem2.m.endpointPresent = 1;
   elem2.endpoint.t = T_ConnectionList_element_endpoint_deviceID;
   elem2.endpoint.u.deviceID = &elem2_deviceID3;

   rtxDListAppend(encodeBuffer.getCtxtPtr(), 
      &conferenced.conferenceConnections, &elem2);

   /* ConferencedEvent.ConnectionList element 3 */
   ASN1T_ConnectionList_element elem3;
    
   ASN1T_DeviceID elem3_staticID;
   elem3_staticID.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   elem3_staticID.deviceIdentifier.u.dialingNumber = "55555";
   ASN1T_ConnectionID_both elem3_both;
   elem3_both.callID.numocts = 1;
   OSOCTET data6 = 0x10;
   elem3_both.callID.data = &data6;
   elem3_both.deviceID.t = T_LocalDeviceID_staticID;
   elem3_both.deviceID.u.staticID = &elem3_staticID;
   elem3.m.newConnectionPresent = 1;
   elem3.newConnection.t = T_ConnectionID_both;
   elem3.newConnection.u.both = &elem3_both;

   ASN1T_DeviceID elem3_deviceID3;
   elem3_deviceID3.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   elem3_deviceID3.deviceIdentifier.u.dialingNumber = "55555";
   elem3.m.endpointPresent = 1;
   elem3.endpoint.t = T_ConnectionList_element_endpoint_deviceID;
   elem3.endpoint.u.deviceID = &elem3_deviceID3;

   rtxDListAppend(encodeBuffer.getCtxtPtr(), 
      &conferenced.conferenceConnections, &elem3);

   /* end of ConferencedEvent.ConnectionList element append */

   /* ConferencedEvent.cause */
   conferenced.cause = EventCause::singleStepConference;

   /* CallControlEvents.ConferencedEvent */
   ASN1T_cerd_CallControlEvents callControlEvents;
   callControlEvents.t = T_cerd_CallControlEvents_conferenced;
   callControlEvents.u.conferenced = &conferenced;

   /* CSTAEventReportArgument */
   eventReportArg.crossRefIdentifier.numocts = 1;
   OSOCTET data7 = 0x99;
   eventReportArg.crossRefIdentifier.data = &data7;
   eventReportArg.eventSpecificInfo.t = T_cerd_EventSpecificInfo_callControlEvents;
   eventReportArg.eventSpecificInfo.u.callControlEvents = &callControlEvents;

   /* Encode */

   len = eventReportArgC.Encode();

   if (len < 0) {
      printf ("Encode of CSTAEventReportArgument failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

/* Encode ROSE header */

static int encodeROSEInvokeHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen)
{
   ASN1T_CSTA_ROSE_PDU pdu;
   ASN1C_CSTA_ROSE_PDU pduC (encodeBuffer, pdu);
   ASN1T_CSTA_ROSE_PDU_invoke invoke;
   int len;

   /* Populate header structure */

   invoke.m.argumentPresent = 1;
   invoke.invokeId.t = T_InvokeId_present;
   invoke.invokeId.u.present = 1; /* arbitrary number: should be unique */
   invoke.opcode.t = T_Code_local;
   invoke.opcode.u.local = 21;   /* opeartion code for "cSTAEventReport" operation from Table 1 */

   /* This is where we get the previously encoded message component..   */
   invoke.argument.numocts = msglen;
   invoke.argument.data = (OSOCTET*) encodeBuffer.getMsgPtr();

   pdu.t = T_CSTA_ROSE_PDU_invoke;
   pdu.u.invoke = &invoke;

   /* Encode */

   len = pduC.Encode();

   if (len < 0) {
      printf ("Encode ROSE PDU failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}
