/* This test driver program encodes a data record and writes the        */
/* encoded result to an output file..                                   */

#include <stdio.h>
#include <stdlib.h>
#include "CSTA-ROSE-PDU-types.h"
#include "CSTA-error-definition.h"

#define MAXMSGLEN 1024

static int encodeMonitorStart_Error (ASN1BEREncodeBuffer& encodeBuffer);

static int encodeROSE_ErrorHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen);

int main (int argc, char** argv)
{
   /* Run-time support variables */

   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int		i, len;
   FILE*        fp;
   const char*        filename = "message.dat";
   OSBOOL     trace = TRUE;

   /* Process command line arguments */

   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) trace = TRUE;
         else if (!strcmp (argv[i], "-o")) filename = argv[++i];
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: writer [ -v ] [ -o <filename>\n");
            printf ("   -v  verbose mode: print trace info\n");
            printf ("   -o <filename>  write encoded msg to <filename>\n");
            printf ("   -notrace  do not display trace info\n");
            return 0;
         }
      }
   }


      /* Initialize the encoding context */

      ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

      /* Encode operation argument */

      if ((len = encodeMonitorStart_Error (encodeBuffer)) < 0) return len;

      /* Encode ROSE header on top of encoded argument */

      if ((len = encodeROSE_ErrorHeader (encodeBuffer, len)) < 0) return len;

      msgptr = encodeBuffer.getMsgPtr();

      if (trace) {
         encodeBuffer.binDump();
      }

      /* Write the encoded message out to the output file */

      /* Note that g++ on Linux suggests the inner parentheses around the
         "assignment used as truth value".  I disagree, but here they are to
         eliminate the warning message.  */
      if ((fp = fopen (filename, "wb"))) {
         fwrite (msgptr, 1, len, fp);
         fclose (fp);
      }
      else {
         printf ("Error opening %s for write access\n", filename);
         return -1;
      }

   return 0;

}

/* Encode "monitorStart" operation Response & Error */

static int encodeMonitorStart_Error (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_UniversalFailure uniFailureError;
   ASN1C_UniversalFailure uniFailureErrorC (encodeBuffer, uniFailureError);
   int len;

   uniFailureError.t = T_UniversalFailure_operation;
   uniFailureError.u.operation = OperationErrors::invalidMonitorObject;

   /* Encode */

   len = uniFailureErrorC.Encode();

   if (len < 0) {
      printf ("Encode of MakeCallResult failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

/* Encode ROSE Error header */

static int encodeROSE_ErrorHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen)
{
   ASN1T_CSTA_ROSE_PDU pdu;
   ASN1C_CSTA_ROSE_PDU pduC (encodeBuffer, pdu);
   ASN1T_ReturnError returnError;
   int len;

   /* Populate header structure */

   returnError.m.parameterPresent = 1;
   returnError.invokeId.t = T_InvokeId_present;
   returnError.invokeId.u.present = 1; /* arbitrary number: should be unique */
   returnError.errcode_.t = T_Code_local;
   returnError.errcode_.u.local = 71;   /* opeartion code for "monitorStart" operation from Table 1 */

   /* This is where we get the previously encoded message component..   */
   returnError.parameter.numocts = msglen;
   returnError.parameter.data = (OSOCTET*) encodeBuffer.getMsgPtr();

   pdu.t = T_CSTA_ROSE_PDU_returnError;
   pdu.u.returnError = &returnError;

   /* Encode */

   len = pduC.Encode();

   if (len < 0) {
      printf ("Encode ROSE PDU failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}
