#include "client.h"

int Client::escapeService(OSRTSocket& cstaSocket)
{
   OSOCTET	msgbuf[MAXMSGLEN];
   int len;

   if (trace) {
      printf ("escape service request \n" );
   }

   /* Initialize the encoding context */

   ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

   /* Encode operation argument */

   if ((len = encodeEscapeServiceRequest (encodeBuffer)) < 0) return len;

   /* Encode ROSE header on top of encoded argument */
   if ((len = encodeROSERequestHeader (encodeBuffer, len, escape_CODE)) < 0) return len;

   /* Write the encoded message out to the socket */

   sendMessage (cstaSocket, encodeBuffer, len);
   if (trace) {
      printf ("Escape Service msg sent, len = %d \n", len);
   }

   int stat = receiveCSTAMessage (cstaSocket);	
   if (stat != 0) {
      printf ("recvMessage failed, %d \n", stat );
      return stat;
   }

   return 0;
}

int Client::encodeEscapeServiceRequest(ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_EscapeArgument escapeArgument;
   ASN1C_EscapeArgument escapeArgumentC (encodeBuffer, escapeArgument);
   int len;

   if (trace) {
       printf ( "encode EscapeArgument Request\n" );
   }

   /* To make it simple, we will omit all of the optional fields */

   escapeArgument.m.escapeRegisterIDPresent = 0;
   escapeArgument.m.securityPresent = 0;

   escapeArgument.privateData.numocts = 4;
   OSOCTET privateData[] = {0x1A, 0x04, 0x01, 0xC0};
   escapeArgument.privateData.data = privateData;

   /* Encode */

   len = escapeArgumentC.Encode();

   if (len < 0) {
      printf ("Encode of EscapeArgument failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

void Client::processEscapeServiceResult(ASN1T_EscapeResult& escapeRes)
{
   //TODO: user action for PBX response to escape service
}
