#include "client.h"

int Client::monitorStop(OSRTSocket& cstaSocket)
{
   if (!monitorInitiated) {
      printf ("Start a monitor first.\n");
      return -1;
   }
	OSOCTET	msgbuf[MAXMSGLEN];
	int len;

	if (trace) {
		printf ("Monitor Stop \n" );
	}

	/* Initialize the encoding context */
	ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

	/* Encode operation argument */
	if ((len = encodeMonitorStopRequest (encodeBuffer, mMostRecentMonitor)) < 0) 
		return len;

	/* Encode ROSE header on top of encoded argument */
	if ((len = encodeROSERequestHeader (encodeBuffer, len, monitorStop_CODE)) < 0) 
		return len;

	/* Write the encoded message out to the socket */

	sendMessage (cstaSocket, encodeBuffer, len);
	if (trace) {
		printf ("monitor stop message sent, len = %d \n", len);
	}

	int stat = receiveCSTAMessage (cstaSocket);
	if (stat != 0) {
		printf ("recvMessage failed, %d \n", stat );
		return stat;
	}
	return 0;
}

int Client::encodeMonitorStopRequest (ASN1BEREncodeBuffer& encodeBuffer,
                                      ASN1T_MonitorCrossRefID& crossRefID)
{
   ASN1T_MonitorStopArgument monStopArgument;
   ASN1C_MonitorStopArgument 
      monStopArgumentC (encodeBuffer, monStopArgument);
   int len;

   /* To make it simple, we will omit all of the optional fields */

   monStopArgument.m.extensionsPresent = 0;
   monStopArgument.crossRefIdentifier.numocts = mMostRecentMonitor.numocts;
   monStopArgument.crossRefIdentifier.data = mMostRecentMonitor.data;

   /* Encode */

   len = monStopArgumentC.Encode();

   if (len < 0) {
      printf ("Encode of MonitorStopArgument failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}


void Client::processMonitorStopRes(ASN1T_MonitorStopResult& monitorStopRes)
{
   //TODO: user action for PBX response to MonitorStop
}
