#include "client.h"

int Client::singleStepTransfer (OSRTSocket& cstaSocket)
{
   OSOCTET	msgbuf[MAXMSGLEN];
   int len;

   if (trace) {
      printf ("Single Step Transfer \n" );
   }

   /* Initialize the encoding context */
   ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

   /* Encode operation argument */
   if ((len = encodeSingleStepTransferRequest(encodeBuffer)) < 0) { return len; }

   /* Encode ROSE header on top of encoded argument */
   if ((len = encodeROSERequestHeader (encodeBuffer, len, singleStepTrans_CODE)) < 0) { return len; }

   /* Write the encoded message out to the socket */
   sendMessage (cstaSocket, encodeBuffer, len);
   if (trace) {
      printf ("Single Step Transfer msg sent, len = %d \n", len);
   }

   int stat = receiveCSTAMessage (cstaSocket);	
   if (stat != 0) {
      printf ("recvMessage failed, %d \n", stat );
      return stat;
   }

   return 0;
}

int Client::encodeSingleStepTransferRequest (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_SingleStepTransArgument singleStepTransArg;
   ASN1C_SingleStepTransArgument singleStepTransArgC (encodeBuffer, singleStepTransArg);
   int len;


   /* To make it simple, we will omit all of the optional fields */
   singleStepTransArg.m.extensionsPresent = 0;

   ASN1T_DeviceID fromStaticID;
   char fromDev[MAX_NUM_SIZE];
   getstring((char *)"Transferring from device no:", fromDev, sizeof(fromDev));
   fromStaticID.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   fromStaticID.deviceIdentifier.u.dialingNumber = fromDev;
   ASN1T_ConnectionID_both bothId;

   char callid[MAX_NUM_SIZE];
   getstring((char *)"Transferring Call Id:", callid, sizeof(callid));
   bothId.callID = callid;
   bothId.deviceID.t = T_LocalDeviceID_staticID;
   bothId.deviceID.u.staticID = &fromStaticID;
   singleStepTransArg.activeCall.t = T_ConnectionID_both;
   singleStepTransArg.activeCall.u.both = &bothId;


   char toDev[MAX_NUM_SIZE];
   getstring((char *)"Transferring to device no:", toDev, sizeof(toDev));
   singleStepTransArg.transferredTo.deviceIdentifier.t =
      T_DeviceID_deviceIdentifier_dialingNumber;
   singleStepTransArg.transferredTo.deviceIdentifier.u.dialingNumber = toDev;

   if (trace) {
	   printf ( "encode Single Step Transfer Request..\n");
      printf ( "  Transfering call %s from %s to %s\n", callid, fromDev, toDev );
   }
   /* Encode */

   len = singleStepTransArgC.Encode();

   if (len < 0) {
      printf ("Encode of singleStepTransArg failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

void Client::processSingleStepTransferRes(ASN1T_SingleStepTransResult& res)
{
   printf("Call transfer completed successfully\n");
   printf("Call transfer information:\n");

   switch (res.transferredCall.t) {
      case T_ConnectionID_both:
         asn1Print_ConnectionID_both ("call", res.transferredCall.u.both);
         break;

      case T_ConnectionID_callID:
         asn1Print_CallID ("call", res.transferredCall.u.callID);
         break;

      case T_ConnectionID_deviceID:
         asn1Print_LocalDeviceID ("call", res.transferredCall.u.deviceID);
         break;

      default:;
   }

}
