#include "client.h"

/* Encode ROSE header */
int Client::systemStatus (OSRTSocket& cstaSocket)
{
   /* receive status from PBX first */
	int stat = receiveCSTAMessage (cstaSocket);	
	if (stat != 0) {
		printf ("recvMessage failed, %d \n", stat );
		return stat;
	}

   /* send client status now */
	OSOCTET	msgbuf[MAXMSGLEN];
	int len;

	if (trace) {
		printf ("Sending system status message ...\n" );
	}

	/* Initialize the encoding context */
	ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

	/* Encode operation argument */
	if ((len = encodeCSTASystemStatusResponse (encodeBuffer)) < 0) { return len; }

	/* Encode ROSE header on top of encoded argument */
	if ((len = encodeROSEResponseHeader (encodeBuffer, len, systemStatus_CODE)) < 0) {
		return len;
   }

	/* Write the encoded message out to the socket */
	sendMessage (cstaSocket, encodeBuffer, len);
	if (trace) {
		printf ("System Status msg sent, len = %d \n", len);
	}

	return 0;
}

int Client::encodeCSTASystemStatusResponse (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_SystemStatusRes systemStatusRes;
   int len;

   if (trace) {
      printf ("encode CSTA System Status Response\n" );
   }

   systemStatusRes.t = T_SystemStatusRes_noData;

   ASN1C_SystemStatusRes pdu (encodeBuffer, systemStatusRes);

   len = pdu.Encode();

   if (len < 0) {
      printf ("Encode SystemStatusRes PDU failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

void Client::processSystemStatusReq( ASN1T_SystemStatusArg& systemStatusArg)
{
   //TODO: user action for PBX request for system status
}

