#!/usr/local/bin/perl
# Execute all sample programs in given subdirectory

select (STDERR);
$| = 1;
select (STDOUT);
$| = 1;

if (@ARGV < 1) {
    print "usage: sample.pl <function> [<make program>]\n";
    print "where <function> = test or clean\n";
    print "      [<make program>] = the optional makefile processor\n";
}

$function = $ARGV[0];
if ($function ne 'test' && $function ne 'clean') {
    die ("invalid function argument: must be test or clean");
}

if (not -e "sample/sample.mk") {
   `cp sample/sample.eval.mk sample/sample.mk`;
}

$makeprog = ($ARGV[1] ne "") ? $ARGV[1] : &getMakeProg;

# try to determine if Windows or UNIX platform type
$os = $ENV{'OS'};
$win32 = ($os =~ /Windows/);
$ENV{"LD_LIBRARY_PATH"} = "../../lib" if (not $win32);
&execSamples ("sample", $function);

sub execSamples {
    local ($dirName) = @_;
    return if (!(-e $dirName));

    chdir ($dirName);
    @dirlist = (`ls .`);

    foreach $filename (@dirlist) {
        $filename =~ s/\n$//;

        if (-d $filename) {
            next if (($filename eq "makeCall_ELF") && $win32);

            chdir ($filename);

            # if special test script exists, execute it (ED, 10/3/02)

            # else execute standard test procedure

            if (-e "makefile") {
                if ($function eq "test") {
                    # major kludge: if java and jsources.mk does not 
                    # exist, create a dummy file
                    if ($subdir eq "java" && ! -e "jsources.mk") {
                        open (MKFILE, ">jsources.mk");
                        print MKFILE "JSOURCES = x.java\n";
                        close (MKFILE);
                    }

                    print "$filename\n";
                    `$makeprog`;

                    if ($filename eq "employee-socketstream") {
                        if ($win32) {
                            print `writer | reader`;
                        }
                        else {
                            print `reader & writer`;
                        }
                    }
                    
                    &doBERTest ($subdir, 0);

                    print "\n";
                    print "**************************************";
                    print "**************************************\n";
                    print "\n";
                }
                elsif ($function eq "clean") {
                    print ("cleaning $filename..\n");
                    if ($subdir eq "java" || $subdir eq "cpp_borland") {
                        # `mv -f Reader.java_save Reader.java`;
                        # `mv -f Writer.java_save Writer.java`;
                        `$makeprog clean`;
                    }
                    else {
                        `$makeprog clean "RM=rm -f"`;
                    }
                }
            }

            chdir ('..');
        }
    }

    chdir ('..');
}

sub doBERTest {
    local ($subdir, $derflag) = @_;

    if ($subdir eq "java") {
        if (-e "writer.log" && -e "writer.glg") {
            print `diff writer.log writer.glg`;
        }
        if (-e "reader.log" && -e "reader.glg") {
            print `diff reader.log reader.glg`;
        }
        if (-e "readeri.log") {
            if (-e "readeri.glg") {
                print `diff readeri.log readeri.glg`;
            }
            elsif (-e "reader.glg") {
                print `diff readeri.log reader.glg`;
            }
        }
    }
    else {
        if (-e "writer.exe" || -e "writer") {
            print ("writer ");
            @proglist = ($win32 ? "writer" : "./writer", "-notrace");
            $stat = system (@proglist);
            if ($stat == 0) { print ("OK\n"); } else { print ("failed.\n"); }
        }

        if (-e "reader.exe" || -e "reader") {
            print ("reader ");
            @proglist = ($win32 ? "reader" : "./reader", "-notrace");
            $stat = system (@proglist);
            if ($stat == 0) { print ("OK\n"); } else { print ("failed.\n"); }
        }

        if (-e "message_ber.dat") {
            print `diff message.dat message_ber.dat`;
        }
    }
}

sub doXERTest {
    local ($subdir) = @_;

    if ($subdir eq "java") {
        if (-e "writer.log" && -e "writer.glg") {
            print `diff writer.log writer.glg`;
        }
        if (-e "reader.log" && -e "reader.glg") {
            print `diff reader.log reader.glg`;
        }
        if (-e "./good/message.xml") {
            print `diff message.xml ./good`;
        }
    }
    else {
        if (-e "writer.exe" || -e "writer") {
            print ("writer ");
            @proglist = ("writer", "-notrace");
            $stat = system (@proglist);
            if ($stat == 0) { print ("OK\n"); } else { print ("failed.\n"); }
        }

        if (-e "reader.exe" || -e "reader") {
            print ("reader ");
            @proglist = ("reader", "-notrace");
            $stat = system (@proglist);
            if ($stat == 0) { print ("OK\n"); } else { print ("failed.\n"); }
        }

        if (-e "./good/message.xml") {
            print `diff message.xml ./good`;
        }
    }
}

sub execBashCmd {
    local ($cmd) = @_;
    if ($verbose) {
        print "$cmd\n";
        print `bash -c "$cmd"`;
    }
    else {
        `bash -c "$cmd"`;
    }
}

sub getMakeProg {
    my $makeprog = "make";
    my $bWindows = 0;
    if (defined ($ENV{'MSVCDIR'}) || 
        defined ($ENV{'VCINSTALLDIR'}) ||
        defined ($ENV{'VSINSTALLDIR'}) ||
        defined ($ENV{'MSDEVDIR'}) ||
		  defined ($ENV{'MSDevDir'})) {
   		  $bWindows = 1;
		  }
	 if ((defined ($ENV{'OS'})) && ($ENV{'OS'} =~ /Windows/)) {
   	 $bWindows = 1;
	 }
    if (defined ($ENV{'MAKEPROG'})) {
        $makeprog = $ENV{'MAKEPROG'};
    }
    elsif ($bWindows) {
        $makeprog = "nmake -nologo";
    }
    else {
        $makeprog = "make";
    }
    return $makeprog;
}
