// This sample program attempts to create a CSTA link with a Siemens 
// PBX via the TCP/IP port..

#include <stdio.h>
#include <stdlib.h>
#include "SiemensClient.h"

int main (int argc, char** argv)
{
   /* Run-time support variables */

   const char*  ipaddr = 0;
   //OSOCTET	msgbuf[MAXMSGLEN];
   int		i, port = 1110;
   OSBOOL     trace = TRUE;

   /* Process command line arguments */

   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) trace = TRUE;
         else if (!strcmp (argv[i], "-ipaddr")) ipaddr = argv[++i];
         else if (!strcmp (argv[i], "-port")) port = atoi (argv[++i]);
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: writer -ipaddr x.x.x.x [ -port x ] [ -v ]\n");
            printf ("   -ipaddr  IP address to connect to\n");
            printf ("   -port    port number\n");
            printf ("   -v       verbose mode: print trace info\n");
            return 0;
         }
      }
   }

   if (0 == ipaddr) {
      printf ("IP address argument (-ipaddr) is required\n");
      return -1;
   }


      OSRTSocket cstaSocket;
      printf ("attempting to connect to %s, port %d..\n", ipaddr, port);
      cstaSocket.connect (ipaddr, port);
      printf ("socket connection established.\n");
      printf ("\n");

      /* Create siemens client to communicate with siemens PBX/server */
      SiemensClient client;
      client.setTrace(trace);

      /* Set up connection with Siemens PBX */
      client.setup(cstaSocket); 

      /******************************************************************/
      /* Connection with device should now be established, additional   */
      /* CSTA operations can now be invoked..                           */
      /* TODO: user commands                                            */
      printf("TODO: perform CSTA operations (e.g. makeCall, ...)\n");
      printf("\n");
      /******************************************************************/

      /* Release connection with Siemens PBX */
      client.release(cstaSocket);


   return 0;
}

