/* This test driver program encodes a data record and writes the        */
/* encoded result to an output file..                                   */

#include <stdio.h>
#include <stdlib.h>
#include "CSTA-ROSE-PDU-types.h"
#include "CSTA-event-report-definitions.h"

#define MAXMSGLEN 1024

static int encodeEventReportRequest (ASN1BEREncodeBuffer& encodeBuffer);

static int encodeROSEInvokeHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen);

int main (int argc, char** argv)
{
   /* Run-time support variables */

   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int		i, len;
   FILE*        fp;
   const char*        filename = "message.dat";
   OSBOOL     trace = TRUE;

   /* Process command line arguments */

   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) trace = TRUE;
         else if (!strcmp (argv[i], "-o")) filename = argv[++i];
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: writer [ -v ] [ -o <filename>\n");
            printf ("   -v  verbose mode: print trace info\n");
            printf ("   -o <filename>  write encoded msg to <filename>\n");
            printf ("   -notrace  do not display trace info\n");
            return 0;
         }
      }
   }


      /* Initialize the encoding context */

      ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

      /* Encode operation argument */

      if ((len = encodeEventReportRequest (encodeBuffer)) < 0) return len;

      /* Encode ROSE header on top of encoded argument */

      if ((len = encodeROSEInvokeHeader (encodeBuffer, len)) < 0) return len;

      msgptr = encodeBuffer.getMsgPtr();

      if (trace) {
         encodeBuffer.binDump();
      }

      /* Write the encoded message out to the output file */

      /* Note that g++ on Linux suggests the inner parentheses around the
         "assignment used as truth value".  I disagree, but here they are to
         eliminate the warning message.  */
      if ((fp = fopen (filename, "wb"))) {
         fwrite (msgptr, 1, len, fp);
         fclose (fp);
      }
      else {
         printf ("Error opening %s for write access\n", filename);
         return -1;
      }

   return 0;

}

/* Encode "Conferenced" event for "cSTAEventReport" operation */

static int encodeEventReportRequest (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_cerd_CSTAEventReportArgument eventReportArg;
   ASN1C_cerd_CSTAEventReportArgument eventReportArgC(encodeBuffer, eventReportArg);
   int len;

   /* To make it simple, we will omit all of the optional fields */
   ASN1T_DeliveredEvent delivered;

   /* ConferencedEvent.connection */
   ASN1T_ConnectionID_both both;
   both.callID.numocts = 1;
   OSOCTET data1 = 0x20;
   both.callID.data = &data1;
   ASN1T_DeviceID staticID;
   staticID.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   staticID.deviceIdentifier.u.dialingNumber = "023";
   both.deviceID.t = T_LocalDeviceID_staticID;
   both.deviceID.u.staticID = &staticID;
   delivered.connection.t = T_ConnectionID_both;
   delivered.connection.u.both = &both;

   /* ConferencedEvent.alertingDevice */
   ASN1T_DeviceID deviceId2;
   deviceId2.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   deviceId2.deviceIdentifier.u.dialingNumber = "18005551212";
   delivered.alertingDevice.t = T_SubjectDeviceID_deviceIdentifier;
   delivered.alertingDevice.u.deviceIdentifier = &deviceId2; 

   /* ConferencedEvent.callingDevice */
   ASN1T_DeviceID deviceId3;
   deviceId3.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   deviceId3.deviceIdentifier.u.dialingNumber = "22343";
   delivered.callingDevice.t = T_CallingDeviceID_deviceIdentifier;
   delivered.callingDevice.u.deviceIdentifier = &deviceId3; 

   /* ConferencedEvent.calledDevice */
   ASN1T_DeviceID deviceId4;
   deviceId4.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   deviceId4.deviceIdentifier.u.dialingNumber = "18005551212";
   delivered.calledDevice.t = T_CalledDeviceID_deviceIdentifier;
   delivered.calledDevice.u.deviceIdentifier = &deviceId4; 

   delivered.lastRedirectionDevice.t = T_RedirectionDeviceID_notRequired;
   delivered.m.localConnectionInfoPresent = 1;
   delivered.localConnectionInfo = LocalConnectionState::alerting;
   delivered.cause = EventCause::networkSignal;

   /* ConferencedEvent.associatedCalledDevice */
   ASN1T_DeviceID deviceId7;
   deviceId7.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   deviceId7.deviceIdentifier.u.dialingNumber = "023";
   delivered.m.associatedCalledDevicePresent = 1;
   delivered.associatedCalledDevice.t = T_AssociatedCalledDeviceID_deviceIdentifier;
   delivered.associatedCalledDevice.u.deviceIdentifier = &deviceId7; 

   /* CallControlEvents.ConferencedEvent */
   ASN1T_cerd_CallControlEvents callControlEvents;
   callControlEvents.t = T_cerd_CallControlEvents_delivered;
   callControlEvents.u.delivered = &delivered;

   /* CSTAEventReportArgument */
   eventReportArg.crossRefIdentifier.numocts = 1;
   OSOCTET data2 = 0x99;
   eventReportArg.crossRefIdentifier.data = &data2;
   eventReportArg.eventSpecificInfo.t = T_cerd_EventSpecificInfo_callControlEvents;
   eventReportArg.eventSpecificInfo.u.callControlEvents = &callControlEvents;

   /* Encode */

   len = eventReportArgC.Encode();

   if (len < 0) {
      printf ("Encode of CSTAEventReportArgument failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

/* Encode ROSE header */

static int encodeROSEInvokeHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen)
{
   ASN1T_CSTA_ROSE_PDU pdu;
   ASN1C_CSTA_ROSE_PDU pduC (encodeBuffer, pdu);
   ASN1T_CSTA_ROSE_PDU_invoke invoke;
   int len;

   /* Populate header structure */

   invoke.m.argumentPresent = 1;
   invoke.invokeId.t = T_InvokeId_present;
   invoke.invokeId.u.present = 1; /* arbitrary number: should be unique */
   invoke.opcode.t = T_Code_local;
   invoke.opcode.u.local = 21;   /* opeartion code for "cSTAEventReport" operation from Table 1 */

   /* This is where we get the previously encoded message component..   */
   invoke.argument.numocts = msglen;
   invoke.argument.data = (OSOCTET*) encodeBuffer.getMsgPtr();

   pdu.t = T_CSTA_ROSE_PDU_invoke;
   pdu.u.invoke = &invoke;

   /* Encode */

   len = pduC.Encode();

   if (len < 0) {
      printf ("Encode ROSE PDU failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}
