/* This test driver program encodes a data record and writes the        */
/* encoded result to an output file..                                   */

#include <stdio.h>
#include <stdlib.h>
#include "CSTA-ROSE-PDU-types.h"
#include "CSTA-get-switching-function-devices.h"

#define MAXMSGLEN 1024

static int encodeGetSwitchingFunctionDevices_Response (ASN1BEREncodeBuffer& encodeBuffer);

static int encodeROSEInvokeHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen);

int main (int argc, char** argv)
{
   /* Run-time support variables */

   const OSOCTET* msgptr;
   OSOCTET	msgbuf[MAXMSGLEN];
   int		i, len;
   FILE*        fp;
   const char*        filename = "message.dat";
   OSBOOL     trace = TRUE;

   /* Process command line arguments */

   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) trace = TRUE;
         else if (!strcmp (argv[i], "-o")) filename = argv[++i];
         else if (!strcmp (argv[i], "-notrace")) trace = FALSE;
         else {
            printf ("usage: writer [ -v ] [ -o <filename>\n");
            printf ("   -v  verbose mode: print trace info\n");
            printf ("   -o <filename>  write encoded msg to <filename>\n");
            printf ("   -notrace  do not display trace info\n");
            return 0;
         }
      }
   }


      /* Initialize the encoding context */

      ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

      /* Encode operation argument */

      if ((len = encodeGetSwitchingFunctionDevices_Response (encodeBuffer)) < 0) return len;

      /* Encode ROSE header on top of encoded argument */

      if ((len = encodeROSEInvokeHeader (encodeBuffer, len)) < 0) return len;

      msgptr = encodeBuffer.getMsgPtr();

      if (trace) {
         encodeBuffer.binDump();
      }

      /* Write the encoded message out to the output file */

      /* Note that g++ on Linux suggests the inner parentheses around the
         "assignment used as truth value".  I disagree, but here they are to
         eliminate the warning message.  */
      if ((fp = fopen (filename, "wb"))) {
         fwrite (msgptr, 1, len, fp);
         fclose (fp);
      }
      else {
         printf ("Error opening %s for write access\n", filename);
         return -1;
      }

   return 0;

}

/* Encode "getSwitchingFunctionDevices" operation Response*/

static int encodeGetSwitchingFunctionDevices_Response (ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_GetSwitchingFunctionDevicesResult getSFDRes;
   ASN1C_GetSwitchingFunctionDevicesResult getSFDResC(encodeBuffer, getSFDRes);
   int len;

   /* To make it simple, we will omit all of the optional fields */

   getSFDRes.serviceCrossRefID.numocts = 1;
   OSOCTET data = 0x30;
   getSFDRes.serviceCrossRefID.data = &data;

   /* Encode */

   len = getSFDResC.Encode();

   if (len < 0) {
      printf ("Encode of GetSwitchingFunctionDevicesResult failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

/* Encode ROSE header */

static int encodeROSEInvokeHeader (ASN1BEREncodeBuffer& encodeBuffer, 
                                   int msglen)
{
   ASN1T_CSTA_ROSE_PDU pdu;
   ASN1C_CSTA_ROSE_PDU pduC (encodeBuffer, pdu);
   ASN1T_ReturnResult returnResult;
   int len;

   /* Populate header structure */

   returnResult.m.resultPresent = 1;
   returnResult.invokeId.t = T_InvokeId_present;
   returnResult.invokeId.u.present = 1; /* arbitrary number: should be unique */
   returnResult.result.opcode.t = T_Code_local;
   returnResult.result.opcode.u.local = 204;   /* opeartion code for "getSwitchingFunctionDevices" operation from Table 1 */

   /* This is where we get the previously encoded message component..   */
   returnResult.result.result.numocts = msglen;
   returnResult.result.result.data = (OSOCTET*) encodeBuffer.getMsgPtr();

   pdu.t = T_CSTA_ROSE_PDU_returnResult;
   pdu.u.returnResult = &returnResult;

   /* Encode */

   len = pduC.Encode();

   if (len < 0) {
      printf ("Encode ROSE PDU failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}
