/* This test driver program encodes a data record and writes the        */
/* encoded result to an output file..                                   */

#include <stdio.h>
#include <stdlib.h>
#include "CSTA-device-identifiers.h"

#define MAXMSGLEN 1024

static void setDeviceIds (ASN1BEREncodeBuffer& encodeBuffer);

int main (int argc, char** argv)
{
      ASN1BEREncodeBuffer encodeBuffer;
      setDeviceIds (encodeBuffer);

   return 0;

}

/* set DeviceID values */

static void setDeviceIds (ASN1BEREncodeBuffer& encodeBuffer)
{
   /*
      <deviceID>4711</deviceID> 
      deviceIdentifier { dialingNumber: 4711}
   */
   ASN1T_DeviceID deviceID1;
   deviceID1.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   deviceID1.deviceIdentifier.u.dialingNumber = "4711";

   /*
      <deviceID typeOfNumber="deviceNumber">100</deviceID> 
      deviceIdentifier { deviceNumber: 100}
   */
   ASN1T_DeviceID deviceID2;
   deviceID2.deviceIdentifier.t = T_DeviceID_deviceIdentifier_deviceNumber;
   deviceID2.deviceIdentifier.u.deviceNumber = 100;

   /*
     <deviceID typeOfNumber="explicitPublic:national">18005551212</deviceID> 
      deviceIdentifier { explicitPublic:national = 18005551212}
   */
   ASN1T_PublicTON explicitPublic;
   explicitPublic.t = T_PublicTON_national;
   explicitPublic.u.national = "18005551212";

   ASN1T_DeviceID deviceID3;
   deviceID3.deviceIdentifier.t = T_DeviceID_deviceIdentifier_explicitPublic;
   deviceID3.deviceIdentifier.u.explicitPublic = &explicitPublic;

   /* 
      <deviceID typeOfNumber="other">abc</deviceID> 
      deviceIdentifier { other = abc }
   */
   OSOCTET data[] = { 0xAB, 0xC0 };
   ASN1T_OtherPlan other;
   other.numocts = 2;
   other.data = data;

   ASN1T_DeviceID deviceID4;
   deviceID4.deviceIdentifier.t = T_DeviceID_deviceIdentifier_other;
   deviceID4.deviceIdentifier.u.other = &other;

   
   /*
      <deviceID mediaClass="voice audio other" switchingSubDomainCCIEType="isdn" bitRate="variable">4711</deviceID>
      
      deviceIdentifier { dialingNumber: 4711}
      mediaCallCharacteristics {
         mediaClass ="voice audio other",  
         switchingSubDomainCCIEType="isdn",
         bitRate="variable" } 
   */
   ASN1T_DeviceID deviceID5;
   deviceID5.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   deviceID5.deviceIdentifier.u.dialingNumber = "4711";

   ASN1C_MediaClass mediaClass5(deviceID5.mediaCallCharacteristics.mediaClass);
   mediaClass5.set(ASN1C_MediaClass::voice);
   mediaClass5.set(ASN1C_MediaClass::audio);
   mediaClass5.set(ASN1C_MediaClass::other);
   deviceID5.mediaCallCharacteristics.switchingSubDomainCCIEType =
      MediaCallCharacteristics_switchingSubDomainCCIEType::isdn;
   deviceID5.mediaCallCharacteristics.bitRate =
      MediaCallCharacteristics_bitRate::variable;

   /*
      <deviceID typeOfNumber="implicitPublic" bitRate="constant" connectionRate="0" delayTolerance="10" mediaClass="voice" switchingSubDomainCCIEType="isdn" switchingSubDomainInformationElements="abcdef">123456</deviceID> 
      
      deviceIdentifier { implicitPublic: 123456}
      mediaCallCharacteristics {
         bitRate="constant",
         connectionRate="0",
         delayTolerance="10",
         mediaClass="voice",
         switchingSubDomainCCIEType="isdn",
         switchingSubDomainInformationElements="abcdef" }
   */
   ASN1T_DeviceID deviceID6;
   deviceID6.deviceIdentifier.t = T_DeviceID_deviceIdentifier_implicitPublic;
   deviceID6.deviceIdentifier.u.implicitPrivate = "4711";
   deviceID5.mediaCallCharacteristics.bitRate =
      MediaCallCharacteristics_bitRate::constant;
   deviceID6.mediaCallCharacteristics.connectionRate = 0;
   deviceID6.mediaCallCharacteristics.delayTolerance = 10;
   ASN1C_MediaClass mediaClass6(deviceID5.mediaCallCharacteristics.mediaClass);
   mediaClass6.set(ASN1C_MediaClass::voice);
   deviceID6.mediaCallCharacteristics.switchingSubDomainCCIEType =
      MediaCallCharacteristics_switchingSubDomainCCIEType::isdn;
   OSOCTET data6[] = { 0xAB, 0xCD, 0xEF };
   deviceID6.mediaCallCharacteristics.switchingSubDomainInformationElements.numocts = 3;
   deviceID6.mediaCallCharacteristics.switchingSubDomainInformationElements.data = data6;

}

