#include "client.h"

int Client::makeCall(OSRTSocket& cstaSocket)
{
   OSOCTET	msgbuf[MAXMSGLEN];
   int len;

   if (trace) {
      printf ("Make Call \n" );
   }

   /* Initialize the encoding context */

   ASN1BEREncodeBuffer encodeBuffer (msgbuf, sizeof(msgbuf));

   /* Encode operation argument */

   if (mMessageType != panasonic) {
      if ((len = encodeMakeCallRequest (encodeBuffer)) < 0) return len;
   }
   else {
      if ((len = encodePanMakeCallRequest (encodeBuffer)) < 0) return len;
   }

   /* Encode ROSE header on top of encoded argument */
   if ((len = encodeROSERequestHeader (encodeBuffer, len, makeCall_CODE)) < 0) return len;

   /* Write the encoded message out to the socket */

   sendMessage (cstaSocket, encodeBuffer, len);
   if (trace) {
      printf ("Make Call msg sent, len = %d \n", len);
   }

   int stat = receiveCSTAMessage (cstaSocket);	
   if (stat != 0) {
      printf ("recvMessage failed, %d \n", stat );
      return stat;
   }

   return 0;
}

int Client::encodeMakeCallRequest(ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_MakeCallArgument makeCallArgument;
   ASN1C_MakeCallArgument makeCallArgumentC (encodeBuffer, makeCallArgument);
   int len;

   char from[MAX_NUM_SIZE];
   char to[MAX_NUM_SIZE];

   getstring((char *)"Calling device :", from, sizeof(from));
   getstring((char *)"Called device :", to, sizeof(to));

   if (trace) {
       printf ( "encode Make Call Request, from %s, to %s \n", from, to );
   }

   /* To make it simple, we will omit all of the optional fields */

   makeCallArgument.callingDevice.m.mediaCallCharacteristicsPresent = 0;
   makeCallArgument.callingDevice.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   makeCallArgument.callingDevice.deviceIdentifier.u.dialingNumber = from;
   makeCallArgument.calledDirectoryNumber.m.mediaCallCharacteristicsPresent = 0;
   makeCallArgument.calledDirectoryNumber.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   makeCallArgument.calledDirectoryNumber.deviceIdentifier.u.dialingNumber = to;
   //makeCallArgument.m.autoOriginatePresent = 1;
   makeCallArgument.autoOriginate = AutoOriginate::doNotPrompt;

   /* Encode */

   len = makeCallArgumentC.Encode();

   if (len < 0) {
      printf ("Encode of MakeCallArgument failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

int Client::encodePanMakeCallRequest(ASN1BEREncodeBuffer& encodeBuffer)
{
   ASN1T_OSysKmeMakeCallArgument makeCallArgument;
   ASN1C_OSysKmeMakeCallArgument makeCallArgumentC (encodeBuffer, makeCallArgument);
   int len;

   char from[MAX_NUM_SIZE];
   char to[MAX_NUM_SIZE];

   getstring((char *)"Calling device :", from, sizeof(from));
   getstring((char *)"Called device :", to, sizeof(to));

   if (trace) {
       printf ( "encode Make Call Request, from %s, to %s \n", from, to );
   }

   /* To make it simple, we will omit all of the optional fields */

   makeCallArgument.callingDevice.m.mediaCallCharacteristicsPresent = 0;
   makeCallArgument.callingDevice.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   makeCallArgument.callingDevice.deviceIdentifier.u.dialingNumber = from;
   makeCallArgument.calledDirectoryNumber.m.mediaCallCharacteristicsPresent = 0;
   makeCallArgument.calledDirectoryNumber.deviceIdentifier.t = T_DeviceID_deviceIdentifier_dialingNumber;
   makeCallArgument.calledDirectoryNumber.deviceIdentifier.u.dialingNumber = to;

   /* Encode */

   len = makeCallArgumentC.Encode();

   if (len < 0) {
      printf ("Encode of MakeCallArgument failed.\n");
      encodeBuffer.printErrorInfo();
   }

   return len;
}

void Client::processMakeCallResult(ASN1T_MakeCallResult& makeCallRes)
{
   mMostRecentCall = makeCallRes.callingDevice;
   callInitiated = TRUE;
   //TODO: additional user actions for PBX response to make call
}
