/* This test driver program encodes a data record and writes the        */
/* encoded result to an output file..                                   */

#include <stdio.h>
#include <stdlib.h>
#include "OSRTSocket.h"

#include <ctype.h>
#include "client.h"

int main (int argc, char** argv)
{
   int i;
   Client client;

   /* Process command line arguments */

   if (argc > 1) {
      for (i = 1; i < argc; i++) {
         if (!strcmp (argv[i], "-v")) client.trace = TRUE;
         else if (!strcmp (argv[i], "-notrace")) client.trace = FALSE;
         else {
            printf ("usage: testClient [-notrace]\n");
            printf ("   -notrace    Disable trace information\n" );
            return 0;
         }
      }
   }

   char ipaddr[16];
   client.getstring((char *)"IP address of PBX/connecting device: ", ipaddr, 16);

   int port = client.getint((char *)"Port number of PBX/connecting device: ");
   printf ("\n");

      /* create socket connection */
      OSRTSocket cstaSocket;
      int socketReturn = cstaSocket.connect (ipaddr, port);
      if (socketReturn < 0) {
         printf ("connect to server socket failed, status = %i \n", socketReturn);
         return -2;
      }

      printf("PBX types: \n");
      printf("---------- \n");
      printf("\t0 - Only CSTA/ACSE message\n");
      printf("\t1 - 2 Length byte + CSTA/ACSE message\n");
      printf("\t2 - Siemens HiPath 3000 series (3350/3300/3550/3750)\n");
      printf("\t3 - Siemens CAP Server\n");
      printf("\t4 - Siemens HiPath 4000 series\n");
      printf("\t5 - Panasonic\n");
      int pbxtype = client.getint((char *)"enter PBX type: ");
      if(pbxtype == 0) {
         client.mMessageType = Client::messageonly;
      }
      else if(pbxtype == 1) {
         client.mMessageType = Client::ietf;
      }
      else if(pbxtype == 2) {
         client.mMessageType = Client::siemens_hipath_3000;
      }
      else if(pbxtype == 3) {
         client.mMessageType = Client::siemens_cap;
      }
      else if(pbxtype == 4) {
         client.mMessageType = Client::siemens_cap;
      }
      else if(pbxtype == 5) {
         client.mMessageType = Client::panasonic;
      }

      int test = 1;
      while (test) {

         printf("\n");
         printf("Test actions: \n");
         printf("------------- \n");
         printf("\t1 - ACSE connection\n");
         printf("\t2 - MakeCall \n");
         printf("\t3 - Transfer Last Call \n");
         printf("\t4 - Answer Last Call \n");
         printf("\t5 - MonitorStart \n");
         printf("\t6 - Stop Last Monitor \n");
         printf("\t7 - Single Step Transfer \n");
         printf("\n");
         printf("\t0 - Quit \n");

         test = client.getint((char *)"enter action number: ");
         printf("\n");

         switch(test) {
            case 1: /* ACSE association */ {
               client.connect(cstaSocket);
            }	
            break;
		
            case 2: /* MakeCall */ {
               client.makeCall(cstaSocket);
            }
            break;

            case 3: /* TransferCall */ {
               client.transferCall(cstaSocket);
            }
            break;

            case 4: /* AnswerCall */ {
               client.answerCall(cstaSocket);
            }
            break;
		
            case 5: /* MonitorStart */ {
               client.monitorStart(cstaSocket);
            }
            break;

            case 6: /* MonitorStop */ {
               client.monitorStop(cstaSocket);
            }
            break;

            case 7: /* SingleStepTransfer */ {
               client.singleStepTransfer(cstaSocket);
            }
            break;

            case 0: { //end of calls
               client.release(cstaSocket);
            }
            break;

            default: {
               printf("Bad action requested !\n");
            }
            break;
         } // switch
      }   //for
      
	return 0;

}

/* get input helper functions */

/* Get a string from command line */
void Client::getstring(char *prompt, char *buf, int size)
{
   printf("%s", prompt);
   fflush(stdout);

   fgets(buf, size, stdin);

   if (buf[strlen(buf) - 1] == '\n')
      buf[strlen(buf) - 1] = '\0';
}

/* Get an integer from command line */
int Client::getint(char *prompt)
{
	int val = 0;
	char buf[32];

	printf("%s", prompt);
	fflush(stdout);

	fgets(buf, sizeof(buf), stdin);
	sscanf(buf, "%d", &val);

	return(val);
}

/* Get an hexa number from command line */
int Client::gethex(char *prompt)
{
	int val = 0;
	char buf[32];

	printf("%s", prompt);
	fflush(stdout);

	fgets(buf, sizeof(buf), stdin);
	sscanf(buf, "%x", &val);

	return(val);
}

